
/***********************************************************************
 * store-arch.c - ddx store architectures
 *
 * CSIRO MANUFACTURING SCIENCE & TECHNOLOGY
 * HIGH-SPEED SERIAL INTERFACE PROJECT
 *
 * $Id: store-arch.c 3842 2008-08-21 08:36:44Z roy029 $
 *
 * Copyright (c) CSIRO Manufacturing Science & Technology.
 *
 ***********************************************************************
 */
#ifdef __GNUC__
#define DDX_STATIC_ATTRIBUTE __attribute__((unused))
#else
#define DDX_STATIC_ATTRIBUTE 
#endif

static char *rcsid DDX_STATIC_ATTRIBUTE = 
	"$Id: store-arch.c 3842 2008-08-21 08:36:44Z roy029 $";

#include "store-arch.h"

STORE_ARCH storeArchs[STORE_ARCH_MAX_NUM] = {
  /* little-endian, Intel */
  {{4, 3, 2, 1}, {0, 0, 1, 2, 4, 4, 4, 8}, {0, 0, 1, 2, 4, 4, 4, 4}},
  /* big-endian, sparc */
  {{1, 2, 3, 4}, {0, 0, 1, 2, 4, 4, 4, 8}, {0, 0, 1, 2, 4, 4, 4, 8}},
  /* little-endian, Intel */
  {{4, 3, 2, 1}, {0, 0, 1, 2, 4, 4, 4, 8}, {0, 0, 1, 2, 4, 4, 4, 4}},
  /* little-endian, arm */
  {{4, 3, 2, 1}, {0, 0, 1, 2, 4, 4, 4, 8}, {0, 0, 1, 2, 4, 4, 4, 8}}
};

int
store_get_arch (
		STORE_ARCH * arch
		)
{
    int i, j, found = 0;

    for (i=0; i<STORE_ARCH_MAX_NUM; i++) {
        found = 1;
        for (j=0; j<4; j++)
	    if (storeArchs[i].swapword[j] != arch->swapword[j]) {
	        found = 0;
	        break;
	    }
	if (! found)
	    continue;
        for (j=0; j<8; j++)
	    if (storeArchs[i].dataSize[j] != arch->dataSize[j]) {
	        found = 0;
	        break;
	    }
	if (! found)
	    continue;
        for (j=0; j<8; j++)
	    if (storeArchs[i].dataAlign[j] != arch->dataAlign[j]) {
	        found = 0;
	        break;
	    }
	if (found)
	    break;
    }
    if (found)
        return (i);
    return (-1);
}

