
/***********************************************************************
 * Catalog-messages.c - ddx catalog messages
 *
 * CSIRO MANUFACTURING SCIENCE & TECHNOLOGY
 * HIGH-SPEED SERIAL INTERFACE PROJECT
 * 
 * $Id: catalog-messages.c 2200 2007-11-23 05:46:38Z roy029 $
 * 
 * Copyright (c) CSIRO Manufacturing Science & Technology.
 *
 ***********************************************************************
 */

#ifdef __GNUC__
#define DDX_STATIC_ATTRIBUTE __attribute__((unused))
#else
#define DDX_STATIC_ATTRIBUTE
#endif
static char *rcsid DDX_STATIC_ATTRIBUTE = "$Id: catalog-messages.c 2200 2007-11-23 05:46:38Z roy029 $";

#include "store-msg.h"
#include "catalog-messages.h"

KEYWORD_TABLE_ENTRY catKeyTable[] = {
    /* MSG_TOK_CATALOG_REGISTER_STORE_REQUEST 0 */
    {0, "$$catalogRegisterStoreRequest", 0},
    /* MSG_TOK_CATALOG_REGISTER_STORE_REPLY 1 */
    {1, "$$catalogRegisterStoreReply", 0},
    /* MSG_TOK_CATALOG_LOOKUP_VAR_REQUEST 2 */
    {2, "$$catalogLookupVarRequest", 0},
    /* MSG_TOK_CATALOG_LOOKUP_VAR_REPLY 3 */
    {3, "$$catalogLookupVarReply", 0},
    /* MSG_TOK_CATALOG_DONE_VAR_REQUEST 4 */
    {4, "$$catalogDoneVarRequest", 0},
    /* MSG_TOK_CATALOG_DONE_VAR_REPLY 5 */
    {5, "$$catalogDoneVarReply", 0},
    /* MSG_TOK_CATALOG_HOST_NAME 6 */
    {6, "$$catalogStoreHostName", 1},
    /* MSG_TOK_CATALOG_PORT_NUM 7 */
    {7, "$$catalogStorePortNum", 1},
    /* MSG_TOK_CATALOG_ALIGNMENT 8 */
    {8, "$$catalogStoreAlignment", 1},
    /* MSG_TOK_CATALOG_BYTE_ORDER 9 */
    {9, "$$catalogStoreByteOrder", 1},
    /* MSG_TOK_CATALOG_DATA_SIZE 10 */
    {10, "$$catalogStoreDataSize", 1},
    /* MSG_TOK_CATALOG_ID 11 */
    {11, "$$catalogStoreId", 1},
    /* MSG_TOK_CATALOG_VAR_NAME 12 */
    {12, "$$catalogVarName", 1},
    /* MSG_TOK_CATALOG_VAR_DECL 13 */
    {13, "$$catalogVarDecl", 1},
    /* MSG_TOK_CATALOG_ERROR_REPLY 14 */
    {14, "$$catalogErrorReply", 0},
    /* MSG_TOK_CATALOG_MESSAGE_ID 15 */
    {15, "$$catalogMessageId", 1},
    /* MSG_TOK_CATALOG_RESPONSE 16 */
    {16, "$$catalogResponse", 1},
    /* MSG_TOK_CATALOG_MULTICAST_ADDR 17 */
    {17, "$$catalogMulticastAddress", 1},
    /* MSG_TOK_CATALOG_MULTICAST_PORT 18 */
    {18, "$$catalogMulticastPort", 1},
    /* MSG_TOK_CATALOG_MULTICAST_ON 19 */
    {19, "$$catalogMulticastOn", 0},
    /* MSG_TOK_CATALOG_MULTICAST_OFF 20 */
    {20, "$$catalogMulticastOff", 0},
    /* MSG_TOK_CATALOG_DEREGISTER_STORE_REQUEST 21 */
    {21, "$$catalogDeregisterStoreRequest", 0},
    /* MSG_TOK_CATALOG_DEREGISTER_STORE_REPLY 22 */
    {22, "$$catalogDeregisterStoreReply", 0},
    /* MSG_TOK_CATALOG_GET_STORE_LIST_REQUEST 23 */
    {23, "$$catalogGetStoreListRequest", 0},
    /* MSG_TOK_CATALOG_GET_STORE_LIST_REPLY 24 */
    {24, "$$catalogGetStoreListReply", 0},
    /* MSG_TOK_CATALOG_GET_ITEM_LIST_REQUEST 25 */
    {25, "$$catalogGetItemListRequest", 0},
    /* MSG_TOK_CATALOG_GET_ITEM_LIST_REPLY 26 */
    {26, "$$catalogGetItemListReply", 0},
    /* MSG_TOK_CATALOG_STORE_LIST 27 */
    {27, "$$catalogStoreList", 1},
    /* MSG_TOK_CATALOG_ITEM_LIST 28 */
    {28, "$$catalogItemList", 1},
    /* MSG_TOK_CATALOG_GET_STORE_INFO_REQUEST 29 */
    {29, "$$catalogGetStoreInfoRequest", 0},
    /* MSG_TOK_CATALOG_GET_STORE_INFO_REPLY 30 */
    {30, "$$catalogGetStoreInfoReply", 0},
    /* MSG_TOK_CATALOG_GET_ITEM_INFO_REQUEST 31 */
    {31, "$$catalogGetItemInfoRequest", 0},
    /* MSG_TOK_CATALOG_GET_ITEM_INFO_REPLY 32 */
    {32, "$$catalogGetItemInfoReply", 0},
    /* MSG_TOK_CATALOG_START_MULTICAST_CMD_TO_STORE 33 */
    {33, "$$catalogStartMulticastCmdToStore", 0},
    /* MSG_TOK_CATALOG_STOP_MULTICAST_CMD_TO_STORE 34 */
    {34, "$$catalogStopMulticastCmdToStore", 0},
    {-1, "", 0}
};

MSG_TABLE_ENTRY catMsgTable [] = {    
    /* MSG_CATALOG_REGISTER_STORE_REQUEST 0 */
    {0, 6, 
        {{MSG_TOK_CATALOG_REGISTER_STORE_REQUEST, 1},
	 {MSG_TOK_CATALOG_HOST_NAME, 1},
	 {MSG_TOK_CATALOG_PORT_NUM, 1},
	 {MSG_TOK_CATALOG_ALIGNMENT, 1},
	 {MSG_TOK_CATALOG_BYTE_ORDER, 1},
	 {MSG_TOK_CATALOG_DATA_SIZE, 1},
	 {-1, 0}}},
    /* MSG_CATALOG_REGISTER_STORE_REPLY 1 */
    {1, 2, 
        {{MSG_TOK_CATALOG_REGISTER_STORE_REPLY, 1},
	 {MSG_TOK_CATALOG_ID, 1},
	 {-1, 0}}},
    /* MSG_CATALOG_LOOKUP_VAR_REQUEST 2 */
    {2, 4, 
        {{MSG_TOK_CATALOG_LOOKUP_VAR_REQUEST, 1},
	 {MSG_TOK_CATALOG_VAR_NAME, 1},
	 {MSG_TOK_CATALOG_HOST_NAME, 1},
	 {MSG_TOK_CATALOG_VAR_DECL, 0},
	 {-1, 0}}},
    /* MSG_CATALOG_LOOKUP_VAR_REPLY 3 */
    {3, 6,
        {{MSG_TOK_CATALOG_LOOKUP_VAR_REPLY, 1},
	 {MSG_TOK_CATALOG_VAR_NAME, 1},
	 {MSG_TOK_CATALOG_VAR_DECL, 1},
	 {MSG_TOK_CATALOG_MULTICAST_ADDR, 1},
	 {MSG_TOK_CATALOG_MULTICAST_PORT, 1},
	 {MSG_TOK_CATALOG_MULTICAST_ON, 0},
	 {-1, 0}}},
    /* MSG_CATALOG_DONE_VAR_REQUEST 4 */
    {4, 3, 
        {{MSG_TOK_CATALOG_DONE_VAR_REQUEST, 1},
	 {MSG_TOK_CATALOG_VAR_NAME, 1},
	 {MSG_TOK_CATALOG_HOST_NAME, 1},
	 {-1, 0}}},
    /* MSG_CATALOG_DONE_VAR_REPLY 5 */
    {5, 2, 
        {{MSG_TOK_CATALOG_DONE_VAR_REPLY, 1},
	 {MSG_TOK_CATALOG_MULTICAST_OFF, 0},
	 {-1, 0}}},
    /* MSG_CATALOG_ERROR_REPLY 3 */
    {6, 3,
        {{MSG_TOK_CATALOG_ERROR_REPLY, 1},
	 {MSG_TOK_CATALOG_RESPONSE, 1},
	 {MSG_TOK_CATALOG_MESSAGE_ID, 1},
	 {-1, 0}}},
    /* MSG_CATALOG_GET_ITEM_INFO_REQUEST 7 */
    {7, 1, 
        {{MSG_TOK_CATALOG_GET_ITEM_INFO_REQUEST, 1},
	 {-1, 0}}},
    /* MSG_CATALOG_GET_ITEM_INFO_REPLY 8 */
    {8, 1, 
        {{MSG_TOK_CATALOG_GET_ITEM_INFO_REPLY, 1},
	 {-1, 0}}},
    /* MSG_CATALOG_DEREGISTER_STORE_REQUEST 9 */
    {9, 2, 
        {{MSG_TOK_CATALOG_DEREGISTER_STORE_REQUEST, 1},
	 {MSG_TOK_CATALOG_HOST_NAME, 1},
	 {-1, 0}}},
    /* MSG_CATALOG_DEREGISTER_STORE_REPLY 10 */
    {10, 1, 
        {{MSG_TOK_CATALOG_DEREGISTER_STORE_REPLY, 1},
	 {-1, 0}}},
    /* MSG_CATALOG_GET_STORE_LIST_REQUEST             11 */
    {11, 1, 
        {{MSG_TOK_CATALOG_GET_STORE_LIST_REQUEST, 1},
	 {-1, 0}}},
    /* MSG_CATALOG_GET_STORE_LIST_REPLY               12 */
    {12, 2, 
        {{MSG_TOK_CATALOG_GET_STORE_LIST_REPLY, 1},
	 {MSG_TOK_CATALOG_STORE_LIST, 0},
	 {-1, 0}}},
    /* MSG_CATALOG_GET_ITEM_LIST_REQUEST              13 */
    {13, 1, 
        {{MSG_TOK_CATALOG_GET_ITEM_LIST_REQUEST, 1},
	 {-1, 0}}},
    /* MSG_CATALOG_GET_ITEM_LIST_REPLY                14 */
    {14, 2, 
        {{MSG_TOK_CATALOG_GET_ITEM_LIST_REPLY, 1},
	 {MSG_TOK_CATALOG_ITEM_LIST, 0},
	 {-1, 0}}},
    /* MSG_CATALOG_GET_STORE_INFO_REQUEST             15 */
    {15, 2, 
        {{MSG_TOK_CATALOG_GET_STORE_INFO_REQUEST, 1},
	 {MSG_TOK_CATALOG_HOST_NAME, 1},
	 {-1, 0}}},
    /* MSG_CATALOG_GET_STORE_INFO_REPLY 16 */
    {16, 7, 
        {{MSG_TOK_CATALOG_GET_STORE_INFO_REPLY, 1},
	 {MSG_TOK_CATALOG_HOST_NAME, 1},
	 {MSG_TOK_CATALOG_PORT_NUM, 1},
	 {MSG_TOK_CATALOG_ALIGNMENT, 1},
	 {MSG_TOK_CATALOG_BYTE_ORDER, 1},
	 {MSG_TOK_CATALOG_DATA_SIZE, 1},
	 {MSG_TOK_CATALOG_MULTICAST_ADDR, 1},
	 {-1, 0}}},
    /* MSG_CATALOG_START_MULTICAST_CMD_TO_STORE       17 */
    {17, 2, 
        {{MSG_TOK_CATALOG_START_MULTICAST_CMD_TO_STORE, 1},
	 {MSG_TOK_CATALOG_VAR_NAME, 1},
	 {-1, 0}}},
    /* MSG_CATALOG_STOP_MULTICAST_CMD_TO_STORE        18 */
    {18, 2, 
        {{MSG_TOK_CATALOG_STOP_MULTICAST_CMD_TO_STORE, 1},
	 {MSG_TOK_CATALOG_VAR_NAME, 1},
	 {-1, 0}}},
    {19, 1,
        {{-1, 0}}}
};
