
/***********************************************************************
 * catalog-main.h - header file for catalog-main module
 *
 * CSIRO MANUFACTURING SCIENCE & TECHNOLOGY
 * HIGH-SPEED SERIAL INTERFACE PROJECT
 * 
 * $Id: catalog-main.h 2204 2007-11-23 06:45:08Z roy029 $
 * 
 * Copyright (c) CSIRO Manufacturing Science & Technology.
 *
 ***********************************************************************
 */

#ifndef __catalog_main_h__
#define __catalog_main_h__

/**
 * The catalog controls the multicast address used by the stores. Each
 * store variable is allocated a unique port number.
 */

/* Initial multicast port number allocated to the first store variable.
 * The port numbers are sequentially allocated, starting with the
 * constant defined here.
 */
#define CATALOG_INIT_MULTI_PORT  10000

/**
 * The two higher-order bytes for the multicast address used by the
 * catalog. The two lower order bytes are determined from the two
 * lower order bytes of the IP address of the host on which the catalog
 * is running. The value defined below is chosen based on RFC 3171
 * and 2365.
 */
#define CATALOG_MULTI_NET_ADDR   "239.255"

/**
 * Maximum number of stores that can connect to a catalog (arbitrary).
 */
#define CATALOG_CLIENTS_MAX      64

/**
 * Maximum size for buffers used internally by the catalog.
 */
#define CATALOG_BUF_SIZE         8192

/**
 * Macro used for debugging.
 */
#define catalog_debug(x) \
    if (catalog->verbose) \
        rtx_message x

/**
 * The catalog maintains a list of the stores that are connected.
 * This structure contains the information stored for each
 * connected store.
 */
typedef struct _store_list_item {
    int portNum;               /**< network port number */
    char * storeHostName;      /**< network hostname */
    int alignment[6];          /**< alignment of basic data types */
    int dataSize[6];           /**< size of basic data types */
    int byteOrder[4];          /**< byte order used by the host */
    RtxInetConn hostaddr;      /**< network-related info */
} STORE_LIST_ITEM;

/**
 * The catalog maintains a list of the variables available in the
 * connected stores. This structure contains the information stored
 * for each store variable.
 */
typedef struct _var_list_item {
    char * name;               /**< variable name */
    char * decl;               /**< variable declaration */
    int multiPort;             /**< network port number for multicasts */
    int activeStores;          /**< number of stores using the variable */
    RtxList * clients;         /**< list of stores using the variable */
} VAR_LIST_ITEM;

/**
 * The catalog structure, used to group together global variables
 * used by the catalog.
 */
typedef struct _catalog {
    int pid;                 /**< self pid */
    int portNum;             /**< network port number of catalog */
    char myHostName[64];     /**< host on which catalog is running */
    int curMultiPort;        /**< current multicast port number */
    char * multiNet;         /**< two higer-order bytes of multicast address */
    char multiAddr[32];      /**< multicast address of catalog */
    int forkFlag;            /**< fork and run in the background */
    int done;                /**< flag to indicate shutdown */
    int verbose;             /**< debug level */
    RtxInet * server;        /**< Inet-related handle */
    RtxList * store;         /**< list of connected stores */
    RtxList * v;             /**< list of store variables */
    RtxMutex * mutex;        /**< mutex for shared access to structure */
} CATALOG;
  
#endif
