
/***********************************************************************
 * catalog-handlers.h - header file for catalog-handlers module
 *
 * CSIRO MANUFACTURING SCIENCE & TECHNOLOGY
 * HIGH-SPEED SERIAL INTERFACE PROJECT
 * 
 * $Id: catalog-handlers.h 2200 2007-11-23 05:46:38Z roy029 $
 * 
 * Copyright (c) CSIRO Manufacturing Science & Technology.
 *
 ***********************************************************************
 */

#ifndef __catalog_handlers_h__
#define __catalog_handlers_h__

int catalog_handle_register_store_request (MSG * mp, char * rxbuf, 
					   char * txbuf, 
					   RtxInetConn * fromAddr, 
					   CATALOG * catalog);
int catalog_handle_lookup_var_request (MSG * mp, char * rxbuf, char * txbuf, 
				       RtxInetConn * fromAddr, 
				       CATALOG * catalog);
int catalog_handle_done_var_request (MSG * mp, char * rxbuf, char * txbuf, 
				     RtxInetConn * fromAddr, 
				     CATALOG * catalog);
int catalog_handle_deregister_store_request (MSG * mp, char * rxbuf, 
					     char * txbuf, 
					     RtxInetConn * fromAddr, 
					     CATALOG * catalog);
int catalog_handle_get_store_list_request (MSG * mp, char * rxbuf, 
					   char * txbuf, 
					   RtxInetConn * fromAddr, 
					   CATALOG * catalog);
int catalog_handle_get_item_list_request (MSG * mp, char * rxbuf, 
					  char * txbuf, 
					  RtxInetConn * fromAddr, 
					  CATALOG * catalog);
int catalog_handle_get_store_info_request (MSG * mp, char * rxbuf, 
					   char * txbuf, 
					   RtxInetConn * fromAddr, 
					   CATALOG * catalog);

/* not strictly a handle, but also use by cleanup function */
int catalog_deregister_store (const char * storeHostName,
					 CATALOG * catalog);

#endif
