#ifndef JPEG_CODEC_H
#define JPEG_CODEC_H

extern "C" {
#include <jpeglib.h>
}
#include "DDXVideo.h"

    
class JpegCodec
{
	public:
		typedef enum {cmAuto, cmGray, cmRGB, cmYUV} ColorSpace;
	protected :
		unsigned int size;
		unsigned int width,height;
		ColorSpace inputColorSpace, outputColorSpace;

		unsigned char * conv_buffer;
		unsigned char * buffer;
		double timestamp;

		int quality; // between 0 and 100
	public :
		JpegCodec(int qual=75);
		void setQuality(int qual);
		int getQuality() const {return quality;}

		virtual ~JpegCodec();

		// virtual when overloading with IPP methods
		virtual bool decodeHeader(const char * filename);
		virtual bool decodeHeader(const unsigned char * src, unsigned int srcsize); 
		virtual bool decode(const char * filename, DDXVideo * dest, 
				unsigned int field=0);
		virtual bool decode(const unsigned char * src, unsigned int srcsize, 
				DDXVideo * dest, unsigned int field=0);

		virtual bool encode(DDXVideo * src, signed int field=0);
		virtual bool encode(DDXVideo * src, const char * filename, unsigned int field=0);

		void setTimeStamp();
		void setTimeStamp(double ts);

		// virtual when overloading with IPP methods
		virtual void setInputColorSpace(ColorSpace cspace);
		virtual void setOutputColorSpace(ColorSpace cspace);

		unsigned int bsize() {return size;}
		bool resizebuffer(unsigned int size);
		const unsigned char * getBuffer() const {return buffer;}
		unsigned char * getBuffer() {return buffer;}
		unsigned int getWidth() {return width;}
		unsigned int getHeight() {return height;}
};




#endif // JPEG_CODEC_H
