#ifndef DDX_VIDEO_CLASS_H
#define DDX_VIDEO_CLASS_H

#include "DDXStore.h"
#include "DDXVariable.h"

#include <ddxvideo.h>

class DDXVideo : public DDXVariable {
	protected :
		struct BaseVideo {
			unsigned int width; 
			unsigned int height; 
			unsigned int frame;
			unsigned int fields;
			unsigned int type;
			unsigned int num_bytes;
			unsigned char bytes[1];	/* Just the beginning of the data buffer */
		};

		BaseVideo * video;

		struct StdVideo {
			int width;
			int height;
			int frame;
			int fields;
			unsigned char bytes[1];	/* Just the beginning of the data buffer */
		};

		StdVideo * std_video;
		unsigned int stdYsize, stdUsize, stdVsize;
		bool parseStdVariable();


	public :
		typedef enum {
			MONO8=0,
			RGB8=1,
			YUV420=2
		} CodingType;
		
		DDXVideo();
		~DDXVideo();

	public :
		// DDX Interfaces 
		bool registerAdvancedVariable(DDXStore & store, const std::string & name, 
				CodingType coding, unsigned int width, unsigned int height, 
				unsigned int nfields=1, bool direct = false);
		bool registerStdVariable(DDXStore & store, const std::string & name, 
				unsigned int width, unsigned int height, 
				unsigned int nfields=1, bool direct = false);

		bool lookupVariable(DDXStore & store, const std::string & name,
				bool direct = false);

	public :
		// Various accessors

		unsigned char * rgbPlane(unsigned int field=0);
		
		unsigned char * YPlane(unsigned int field=0);
		unsigned char * UPlane(unsigned int field=0);
		unsigned char * VPlane(unsigned int field=0);
		
		unsigned char * greyPlane(unsigned int field=0);

		// Various accessors, the same but const
		const unsigned char * rgbPlane(unsigned int field=0) const;
		
		const unsigned char * YPlane(unsigned int field=0) const;
		const unsigned char * UPlane(unsigned int field=0) const;
		const unsigned char * VPlane(unsigned int field=0) const;
		
		const unsigned char * greyPlane(unsigned int field=0) const;

		unsigned int width() const;
		unsigned int height() const;
		CodingType type() const;
		unsigned int frame() const;
		unsigned int fields() const;
		void setFrame(unsigned int f);
		bool setSize(unsigned int width,unsigned int height);

	public :
		// TODO: modify these function to read/write all fields as a single
		// image when the field is -1
		
		// The function below read a buffer of a given format and store it in
		// the video object. Beware that not all conversion are implemented.
		void readMono(const unsigned char * buffer, unsigned int field = 0);
		// same as above, but handle the any stride
		void readMonoWithStride(const unsigned char * buffer, unsigned int stride, unsigned int field = 0);
		void readMono16(const unsigned char * buffer, unsigned int field = 0);
		void readRGB(const unsigned char * buffer, unsigned int field = 0);
		void readYCbCr(const unsigned char * buffer,unsigned int field = 0);
		void readYUV411(const unsigned char * buffer, unsigned int field = 0);
		void readYUV422(const unsigned char * buffer, unsigned int field = 0);
		void readYUV444(const unsigned char * buffer, unsigned int field = 0);
		void readBayerRGGB(const unsigned char * buffer, unsigned int field = 0);
		void readBayerBGGR(const unsigned char * buffer, unsigned int field = 0);
		void readBayerYUYV(const unsigned char * buffer, unsigned int field = 0);

		// The functions below assume the buffer has been allocate with the
		// appropriate size.
		// Write the video buffer as a YCbCr buffer, YUVYUV..., buffer size
		// should be width*height*3
		bool convertToYCbCr(unsigned char * buffer, unsigned int field = 0) const;
		// Write the video buffer as a RGB buffer, RGBRGB..., buffer size
		// should be width*height*3
		bool convertToRGB(unsigned char * buffer, unsigned int field = 0) const;
		// Write the video buffer as a Gray Level buffer, YYYYY..., buffer size
		// should be width*height
		bool convertToMono(unsigned char * buffer, unsigned int field = 0) const;

		bool saveAsTga(const char * fname,unsigned int field=0) const;
};



#endif // DDX_VIDEO_CLASS_H
