#ifndef DDX_TEMPLATE_VAR_H
#define DDX_TEMPLATE_VAR_H

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string>

#include "DDXStore.h"
#include "DDXVariable.h"

template <class C> 
class DDXTemplateVariable : public DDXVariable
{
	public:
		DDXTemplateVariable() {}

		bool registerVariable(DDXStore & store,
				const std::string & name, 
				bool direct = false) 
		{
			bool ret;
			char tmp[128];
			sprintf(tmp,"struct { char data[%u];} %s_type;",
					sizeof(C),name.c_str());
			ret = store.registerType(std::string(tmp));
			if (!ret) return false;
			ret = store.registerVariable(name,name+"_type");
			if (!ret) return false;
			ret = store.lookupVariable(*this,name,direct);
			if (!ret) return false;
			return true;
		}
		~DDXTemplateVariable() {}

		C* pointer() {return (C*)(rawPointer());}
		const C* pointer() const {return (C*)(rawPointer());}
};

#endif // DDX_TEMPLATE_VAR_H
