/**
 * \file DDXTCPClient.h
 * \class DDXTCPClient
 * \brief The TCPClient represents a class which can send and receive data using a TCP connection.
 * This class build around rtx_inet functions
 *
 * \author Navid Nourani-Vatani
 * \version 1.0.20070219
 */

#ifndef _TCPCLIENT_H_
#define _TCPCLIENT_H_

// C / C++ libs
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <string>
// CSIRO libs
#include <rtx/main.h>
#include <rtx/error.h>
#include <rtx/inet.h>
#include <rtx/message.h>
#include <rtx/param.h>
#include <rtx/serial.h>
#include <rtx/signal.h>
#include <rtx/timer.h>
#include <rtx/thread.h>


class DDXTCPClient {
  
 protected:
  RtxInet * tcpHandle;
  std::string remoteHost;
  int remotePort;

 public:
  /**
   * \brief Constructor initializes class to default settings
   */
  DDXTCPClient( void );
  /**
   * \brief Constructor initializes class and connects to the given host.
   * \param const std::string host - Host IP
   * \param const int port - Host port
   */
  DDXTCPClient( const std::string, const int );
  /**
   * \brief Destructor closes connection.
   */
  ~DDXTCPClient( void );

  /**
   * \brief If a connection is present this is closed
   * \return bool - true if successful
   */
  bool closeConnection( void );  
  /**
   * \brief initializes the connection if a remote host and port is set.
   * \return bool - true if successful
   */
  bool initConnection( void );
  /**
   * \brief Checks if a connection is present.
   * \return bool - true if connected
   */
  bool isConnected( void ) const;
  
  /**
   * \brief Receives the next message in queue from host.
   * \param std::string * msg - Pointer to a string to contain the message.
   * \param const int msgLength - A default msg length of 1024 is used. This can be overwritten here.
   * \return bool - true if successful
   */
  bool receive( std::string * msg, const int msgLength=1024 );
  /**
   * \brief Send a msg to host
   * \param const std::string msg - Message to be sent
   * \return bool - true if successful
   */
  bool send( const std::string msg );

  /**
   * \brief Sets the IP of remote host
   * \param const std::string host - Name or IP of host.
   * \return bool - true if successful
   */
  bool setRemoteHost( const std::string );
  /**
   * \brief Sets the port of remote host
   * \param const int port - Host port
   * \return bool - true if successful
   */
  bool setRemotePort( const int );
};

#endif // _TCPCLIENT_H_
