#ifndef DDX_STORE_H
#define DDX_STORE_H
#include <string>
#include <vector>

#define float_t float_type
#define double_t double_type
#include <ddx.h>
#undef double_t
#undef float_t

#include "DDXVariable.h"

class DDXStore {
	protected :
		bool verbose;
		DDX_STORE_ID * storeId;
		void updateList(std::vector<std::string> & objname) const;

	public :
		DDXStore(bool verb=true);
		~DDXStore();
		// in order to use direct ddx functions
		DDX_STORE_ID * getId() {return storeId;}

	public :
		// DDX Interfaces 
		bool open(const char * storeName = NULL,
				unsigned int storePort=0,unsigned int timeout=5);
		bool open(const std::string & storeName,
				unsigned int storePort=0,unsigned int timeout=5);
		bool close();
		
	public :
		// DDX Constant Interfaces 
		bool listConstants(std::vector<std::string> & constants) const;
		bool registerConstant(const std::string & constName, int value);
		bool lookupConstant(const std::string & constName, int & value) const;
		
	public :
		// DDX Type Interfaces 
		bool listTypes(std::vector<std::string> & types) const;
		bool registerType(const std::string & typeDefinition);
		bool lookupType(const std::string & typeName,
				std::string & typeDefinition) const;
		
	public :
		// DDX Variable Interfaces 
		bool listVariables(std::vector<std::string> & variables) const;
		
		bool registerVariable(DDXVariable & var,
				const std::string & variableName,
				const std::string & typeName,
				bool direct = false);
		
		bool registerVariable(const std::string & variableName,
				const std::string & typeName);
		
		bool lookupVariable(DDXVariable & var,
				const std::string & variableName,
				bool direct = false) const;

		bool exists( const std::string & variableName) const;
};
		




#endif // DDX_STORE_H
