#include <string.h>

#include "DDXSerialComm.h"

/** **************************************************
 *
 */
DDXSerialComm::DDXSerialComm( void ) {
  setLine( "/dev/ttyS0" );
  setBaud( 9600 );
  setDataBits( 8 );
  setStopBits( 1 );
  setParity( RTX_SERIAL_PARITY_NONE  );
  setFlow( RTX_SERIAL_FLOW_NONE );
  setModem( RTX_SERIAL_MODEM_OFF );
  setVmin( 0 );
  setVtime( 0 );
  
  this->connected = false;
  
}
/** **************************************************
 *
 */
DDXSerialComm::DDXSerialComm( const std::string line, const int baud ) {

  setLine( line );
  setBaud( baud );
  setDataBits( 8 );
  setStopBits( 1 );
  setParity( RTX_SERIAL_PARITY_NONE  );
  setFlow( RTX_SERIAL_FLOW_NONE );
  setModem( RTX_SERIAL_MODEM_OFF );
  setVmin( 0 );
  setVtime( 0 );

  this->connected = false;
  
}
/** **************************************************
 *
 */
DDXSerialComm::~DDXSerialComm( void ) {
  closeComm();
}

/** **************************************************
 *
 */
bool DDXSerialComm::closeComm( void ) {
  if( this->connected ) {
    rtx_serial_close( fileDesc );
    this->connected = false;
  }
  return true;
}
/** **************************************************
 *
 */
bool DDXSerialComm::flush( void ) const {
  // Flush port
  rtx_serial_flush_input( this->fileDesc );
  rtx_serial_flush_output( this->fileDesc );
  return true;
}

/** **************************************************
 *
 */
bool DDXSerialComm::initComm( void ) {
  
  // Close connection if one already exists
  if( this->connected ) {
    closeComm();
  }

  // Open connection using rtx
  this->fileDesc = rtx_serial_open( (char *)this->device.c_str(),
				    this->baud, 
				    this->dataBits, 
				    this->stopBits, 
				    this->parity, 
				    this->flow, 
				    this->modem, 
				    this->vMin, 
				    this->vTime );
  if( this->fileDesc == -1 ) {
    this->connected = false;
    return false;
  }
  this->connected = true;

  return true;
}

/** **************************************************
 *
 */
bool DDXSerialComm::receive( std::string * msgPtr ) {
  /*
  // Check correct initialization
  if( this->header.empty() ) {
    print.error( "No header has been defined.\n" );
    return false;
  }
  */
  /*
  if( this->packetLength <= 0 ) {
    print.error( "Invalid packet length.\n" );
    return false;
  }
  */

  char buffer;
  (*msgPtr).clear();

  // Clear old data from msg string
  if( ! this->msg.empty() && this->msg[0] != this->syncByte ) {
    this->msg.clear();
  }

  if( this->msg.empty() ) {
    // Find the sync byte
    while( true ) {
      rtx_serial_read( this->fileDesc, &buffer, 1 );
      //display_bits( buffer, 8 );
      //printf("%02X ", buffer);

      if( memcmp( &buffer, &this->syncByte, sizeof(char) ) == 0 ) {
	this->msg.assign( 1, buffer );
	//print.info( "Got header\n"  );
	break;
      }
      //else {
      //print.info( " not header\n" );
      //}

    }
  }
  // Get rest of msg until next sync byte is seen
  while( true ) {
    rtx_serial_read( this->fileDesc, &buffer, 1 );
    //display_bits( buffer, 8 ); 
    // Next sync byte seen. Copy to msgPtr and keep sync byte
    if( memcmp( &buffer, &this->syncByte, sizeof(char) ) == 0 ) {
      *msgPtr = this->msg;

      this->msg.clear();
      this->msg.assign( &buffer, 1 );
      break;
    }
    else {
      this->msg.append( &buffer, 1 );
    }

  }

  return true;
}
/** **************************************************
 *
 */
bool DDXSerialComm::send( const std::string msg ) const {
  char c_msg[msg.size()];
  if( msg.copy( c_msg, msg.size(), 0 ) != msg.size() ) {
    //print.error( "Could not allocate memory to send msg!\n" );
    return false;
  }

  flush();
  int sent = write( this->fileDesc, &c_msg, msg.size() );
  if( sent > 0 ) {
    return true;
  }
  return false;
}

/***************************** SET FUNCTIONS *********************************/

/** **************************************************
 *
 */
bool DDXSerialComm::setPacketLength( const int packetLength ) {
  if( packetLength <= 0 ) {
    return false;
  }
  if( packetLength < 2 ) {
    return false;
  }
  this->packetLength = packetLength;

  return true;
}
/** **************************************************
 *
 */
bool DDXSerialComm::setSyncByte( const unsigned char syncByte ) {
  this->syncByte = syncByte;
  return true;
}
/** **************************************************
 *
 */
bool DDXSerialComm::setLine( const std::string dev ) {
  this->device = dev;
  return true;
}
/** **************************************************
 *
 */
bool DDXSerialComm::setBaud( const int baud ) {
  const int BAUD_VALUES[19] = {   110,     300,    1200,    2400,    4800,  
				 9600,   19200,   28800,   38400,   57600, 
				76800,  115200,  230400,  460800,  921600, 
			      1382400, 1843200, 2764800};
  for( int i = 0; i < 19; i++ ) {
    if( baud == BAUD_VALUES[i] ) {
      this->baud = baud;
      return true;
    }
  }
  return false;
}
/** **************************************************
 *
 */
bool DDXSerialComm::setDataBits( const int dataBits ) {
  if( dataBits == 7 || dataBits == 8 ) {
    this->dataBits = dataBits;
    return true;
  }
  return false;
}
/** **************************************************
 *
 */
bool DDXSerialComm::setStopBits( const int stopBits ) {
  if( stopBits == 1 || stopBits == 2 ) {
    this->stopBits = stopBits;
    return true;
  }
  return false;
}
/** **************************************************
 *
 */
bool DDXSerialComm::setParity( const RtxSerialParity parity ) {
  this->parity = parity;
  return true;
}
/** **************************************************
 *
 */
bool DDXSerialComm::setFlow( const RtxSerialFlow flow ) {
  this->flow = flow;
  return true;
}
/** **************************************************
 *
 */
bool DDXSerialComm::setModem( const RtxSerialModem modem ) {
  this->modem = modem;
  return true;
}
/** **************************************************
 *
 */
bool DDXSerialComm::setVmin( const int vMin ) {
  this->vMin = vMin;
  return true;
}
/** **************************************************
 *
 */
bool DDXSerialComm::setVtime( const int vTime) {
  this->vTime = vTime;
  return true;
}
