#include <signal.h>

#include "DDXStore.h"
#include "DDXVariable.h"
#include <string>

using namespace std;

int end = 0;
void sighdl(int n) {
	end += 1;
}

int main(int argc, char * argv[])
{
	if (argc < 2) {
		printf("Usage: %s varname \n",argv[0]);
		return 1;
	}
	DDXStore store;
	DDXVariable V;
	if (!store.open()) {
		fprintf(stderr, "Failed to open store\n");
		printf("Usage: %s varname filename\n",argv[0]);
		return 1;
	}

	string arg(argv[1]);
	unsigned int pos = arg.find_first_of(".");
	bool subvar = (pos != string::npos);
	
	string varname,varpath;
	if (subvar) {
		varname = arg.substr(0,pos);
		varpath = arg.substr(pos,arg.length()-pos);
	} else {
		varname = arg;
		varpath = "";
	}
	printf("# Variable '%s' Path '%s'\n",varname.c_str(),varpath.c_str());


	if (!store.lookupVariable(V,varname)) {
		fprintf(stderr, "Failed to lookup '%s'\n",varname.c_str());
		printf("Usage: %s varname \n",argv[0]);
		return 1;
	}

	try {
		V.read(1,0);
		printf("%e %e\n",V.timeStamp(),V.get(varpath).asDouble());
		signal(SIGINT,sighdl);
		while (!end) {
			if (V.read(1.0,1)) {
				printf("%e %e\n",V.timeStamp(),V.get(varpath).asDouble());
			}
		}
	} catch (const std::exception & e) {
		printf("V.get failed with '%s'\n",e.what());
	}

	return 0;
		
}



