#ifndef DDXWEB_RENDER_H
#define DDXWEB_RENDER_H


#include <string>
#include <ddx.h>
#include <rtx/parse.h>


std::string renderVarAsText(std::string & s, RtxParseVar * v,unsigned int dim,int * arrayDim,
		unsigned int indentLevel, bool pretty, void * buffer);

std::string renderVarAsHTML(std::string & s, RtxParseVar * v,unsigned int dim,int * arrayDim,
		unsigned int indentLevel, bool pretty, void * buffer, bool form=false, const std::string & varname="");

std::string renderVarAsXML(std::string & s, RtxParseVar * v,unsigned int dim,int * arrayDim,
		unsigned int indentLevel, bool pretty, void * buffer, double timeStamp);
		
std::string renderVarAsXSD(std::string & s, RtxParseVar * v,unsigned int dim,int * arrayDim,
		unsigned int indentLevel, bool pretty, void * buffer);

std::string renderVarAsSVG(std::string & s, DDXLaser * laser);



#endif // DDXWEB_RENDER_H
