#include <string.h>
#include <ddx.h>
#include <DDXLaser.h>
#include <rtx/parse.h>
#include <cmath>
#include <exception>

using namespace std;

#define MIN(a,b) (((signed)(a)<(signed)(b))?(a):(b))

class RenderNotImplemented : public exception
{
	public:
		const char * what() const throw () {
			return "Rendering not implemented for this object";
		}
};

string renderVarAsText(string & s, RtxParseVar * v,unsigned int dim,int * arrayDim,
		unsigned int indentLevel, bool pretty, void * vbuffer)
{
	char * buffer = (char*)vbuffer;
	char tmp[1024];
	int i;
	unsigned int ui;

	if (v == NULL)
		return s;

	if (pretty) {
		for (ui=0; ui<indentLevel; ui++) 
			tmp[ui] = '\t';
		tmp[indentLevel] = 0;
		s += tmp;
	}
	if (v->type == rtx_struct_t) {
		RtxParseVar * vit = v->subVar;
		sprintf(tmp,"struct {%c",pretty?'\n':' ');
		s += tmp;
		while (vit != NULL) {
			s = renderVarAsText (s, vit, vit->dim, vit->arrayDim, indentLevel+1, 
					pretty,(buffer==NULL)?NULL:(buffer + vit->offset));
			vit = vit->next;
		}
		if (pretty) {
			for (ui=0; ui<indentLevel; ui++) 
				tmp[ui] = '\t';
			strcpy(tmp+indentLevel,"} ");
			s += tmp;
		} else {
			s += "} ";
		}
	} else {
		switch (v->type) {
			case rtx_char_t : 
				s += "char ";
				break;
			case rtx_short_t : 
				s += "short ";
				break;
			case rtx_int_t : 
				s += "int ";
				break;
			case rtx_long_t : 
				s += "long ";
				break;
			case rtx_float_t : 
				s += "float ";
				break;
			case rtx_double_t : 
				s += "double ";
				break;
		}
	}
	s += v->name;
	for (ui=0; ui<dim; ui++) {
		sprintf (tmp,"[%d]", arrayDim[ui]);
		s += tmp;
	}
	if ((v->type == rtx_struct_t) && (dim>0)) {
		s += " ... (displaying first object only)";
	}
	if (buffer != NULL) {
		switch (v->type) {
			case rtx_char_t : 
				{
					char *c = (char *)(buffer);
					switch (dim) {
						case 0: 
							if (isprint(*c)) {
								sprintf(tmp," = %d 0x%02X '%c'",*c,*c,*c); 
							} else {
								sprintf(tmp," = %d 0x%02X ",*c,*c); 
							}
							s += tmp;
							break;
						case 1: 
							s += " = [ ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%02X ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "...] = '";
							} else {
								s += "] = '";
							}
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								if (isprint(c[i])) {
									s += c[i];
								} else {
									sprintf(tmp,"\\%03o",c[i]);
									s += tmp;
								}
							}
							if (arrayDim[0] > 10) { 
								s += "...'";
							} else {
								s += "'";
							}
							break;
						default : break;
					}
				}
				break;
			case rtx_short_t : 
				{
					short * c = (short *)(buffer);
					switch (dim) {
						case 0: 
							sprintf(tmp," = %d 0x%04X",*c,*c); 
							s += tmp;
							break;
						case 1: 
							s += " = [ ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%d ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "...]";
							} else {
								s += "]";
							}
							break;
						default : break;
					}
				}
				break;
			case rtx_int_t : 
				{
					int * c = (int *)(buffer);
					switch (dim) {
						case 0: 
							sprintf(tmp," = %d",*c); 
							s += tmp;
							break;
						case 1: 
							s += " = [ ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%d ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "...]";
							} else {
								s += "]";
							}
							break;
						default : break;
					}
				}
				break;
			case rtx_long_t : 
				{
					long * c = (long *)(buffer);
					switch (dim) {
						case 0: 
							sprintf(tmp," = %ld 0x%08lX",*c,*c); 
							s += tmp;
							break;
						case 1: 
							s += " = [ ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%ld ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "...]";
							} else {
								s += "]";
							}
							break;
						default : break;
					}
				}
				break;
			case rtx_float_t :
				{
					float * c = (float *)(buffer);
					switch (dim) {
						case 0: 
							sprintf(tmp," = %e",*c); 
							s += tmp;
							break;
						case 1: 
							s += " = [ ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%e ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "...]";
							} else {
								s += "]";
							}
							break;
						default : break;
					}
				}
				break;
			case rtx_double_t :
				{
					double * c = (double *)(buffer);
					switch (dim) {
						case 0: 
							sprintf(tmp," = %e",*c); 
							s += tmp;
							break;
						case 1: 
							s += " = [ ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%e ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "...]";
							} else {
								s += "]";
							}
							break;
						default : break;
					}
				}
				break;
		}
	}
	if (pretty)
		s += ";\n";
	else
		s += "; ";
	return s;
}


string renderVarAsHTML(string & s, RtxParseVar * v,unsigned int dim,int * arrayDim,
		unsigned int indentLevel, bool pretty, void * vbuffer,bool form,const string & varname)
{
	char * buffer = (char*)vbuffer;
	char tmp[1024];
	unsigned int ui;
	signed int i;

	if (v == NULL)
		return s;

	if (form) {pretty = 1;}

	if (pretty) {
		if (indentLevel == 0) {
			if (form) {
				s += "<form id=\"ddxform\" name=\"ddxform\" method=\"post\">\n";
			}
			s += "<pre>\n";
		}
		for (ui=0; ui<indentLevel; ui++) 
			tmp[ui] = '\t';
		tmp[indentLevel] = 0;
		s += tmp;
	}
	if (v->type == rtx_struct_t) {
		RtxParseVar * vit = v->subVar;
		sprintf(tmp,"<em>struct</em> {%c",pretty?'\n':' ');
		s += tmp;
		// Warning: we disable form output here for array of struct
		if (v->dim > 0) {
			form = false;
		}
		while (vit != NULL) {
			s = renderVarAsHTML (s, vit, vit->dim, vit->arrayDim, indentLevel+1, 
					pretty,(buffer==NULL)?NULL:(buffer + vit->offset),form,varname+'.'+vit->name);
			vit = vit->next;
		}
		if (pretty) {
			for (ui=0; ui<indentLevel; ui++) 
				tmp[ui] = '\t';
			strcpy(tmp+indentLevel,"} ");
			s += tmp;
		} else {
			s += "} ";
		}
	} else {
		switch (v->type) {
			case rtx_char_t : 
				s += "<em>char</em> ";
				break;
			case rtx_short_t : 
				s += "<em>short</em> ";
				break;
			case rtx_int_t : 
				s += "<em>int</em> ";
				break;
			case rtx_long_t : 
				s += "<em>long</em> ";
				break;
			case rtx_float_t : 
				s += "<em>float</em> ";
				break;
			case rtx_double_t : 
				s += "<em>double</em> ";
				break;
		}
	}
	s += "<b>";
	s += v->name;
	s += "</b><em>";
	for (ui=0; ui<dim; ui++) {
		sprintf (tmp,"[%d]", arrayDim[ui]);
		s += tmp;
	}
	s += "</em>";
	if ((v->type == rtx_struct_t) && (dim>0)) {
		s += " <u>displaying first object only</u>";
	}
	if (buffer != NULL) {
		switch (v->type) {
			case rtx_char_t : 
				{
					char *c = (char *)(buffer);
					switch (dim) {
						case 0: 
							if (form) {
								sprintf(tmp," = <input type=\"text\" name=\"%s\" value=\"%d\"/>",varname.c_str(),(int)*c);
							} else if (isprint(*c)) {
								sprintf(tmp," = <font color=blue>%d 0x%02X '%c'</font>",*c,*c,*c); 
							} else {
								sprintf(tmp," = <font color=blue>%d 0x%02X </font>",*c,*c); 
							}
							s += tmp;
							break;
						case 1: 
							s += " = [<font color=blue> ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%02X ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "</font>...] = '<font color=blue>";
							} else {
								s += "</font>] = '<font color=blue>";
							}
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								if (isprint(c[i])) {
									s += c[i];
								} else {
									sprintf(tmp,"\\%03o",c[i]);
									s += tmp;
								}
							}
							if (arrayDim[0] > 10) { 
								s += "</font>...'";
							} else {
								s += "</font>'";
							}
							break;
						default : break;
					}
				}
				break;
			case rtx_short_t : 
				{
					short * c = (short *)(buffer);
					switch (dim) {
						case 0: 
							if (form) {
								sprintf(tmp," = <input type=\"text\" name=\"%s\" value=\"%d\"/>",varname.c_str(),(int)*c);
							} else {
								sprintf(tmp," = <font color=blue>%d 0x%04X</font>",*c,*c); 
							}
							s += tmp;
							break;
						case 1: 
							s += " = [<font color=blue> ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%d ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "</font>...]";
							} else {
								s += "</font>]";
							}
							break;
						default : break;
					}
				}
				break;
			case rtx_int_t : 
				{
					int * c = (int *)(buffer);
					switch (dim) {
						case 0: 
							if (form) {
								sprintf(tmp," = <input type=\"text\" name=\"%s\" value=\"%d\"/>",varname.c_str(),(int)*c);
							} else {
								sprintf(tmp," = <font color=blue>%d</font>",*c); 
							}
							s += tmp;
							break;
						case 1: 
							s += " = [<font color=blue> ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%d ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "</font>...]";
							} else {
								s += "</font>]";
							}
							break;
						default : break;
					}
				}
				break;
			case rtx_long_t : 
				{
					long * c = (long *)(buffer);
					switch (dim) {
						case 0: 
							if (form) {
								sprintf(tmp," = <input type=\"text\" name=\"%s\" value=\"%d\"/>",varname.c_str(),(int)*c);
							} else {
								sprintf(tmp," = <font color=blue>%ld 0x%08lX</font>",*c,*c); 
							}
							s += tmp;
							break;
						case 1: 
							s += " = [<font color=blue> ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%ld ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "</font>...]";
							} else {
								s += "</font>]";
							}
							break;
						default : break;
					}
				}
				break;
			case rtx_float_t :
				{
					float * c = (float *)(buffer);
					switch (dim) {
						case 0: 
							if (form) {
								sprintf(tmp," = <input type=\"text\" name=\"%s\" value=\"%f\"/>",varname.c_str(),(double)*c);
							} else {
								sprintf(tmp," = <font color=blue>%e</font>",*c); 
							}
							s += tmp;
							break;
						case 1: 
							s += " = [<font color=blue> ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%e ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "</font>...]";
							} else {
								s += "</font>]";
							}
							break;
						default : break;
					}
				}
				break;
			case rtx_double_t :
				{
					double * c = (double *)(buffer);
					switch (dim) {
						case 0: 
							if (form) {
								sprintf(tmp," = <input type=\"text\" name=\"%s\" value=\"%f\"/>",varname.c_str(),(double)*c);
							} else {
								sprintf(tmp," = <font color=blue>%e</font>",*c); 
							}
							s += tmp;
							break;
						case 1: 
							s += " = [<font color=blue> ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%e ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "</font>...]";
							} else {
								s += "</font>]";
							}
							break;
						default : break;
					}
				}
				break;
		}
	}
	if (pretty)
		s += ";\n";
	else
		s += "; ";
	if (pretty && (indentLevel == 0)) {
		s += "</pre>\n";
		if (form) {
			s += "<input type=\"submit\"/>\n";
			s += "</form>\n";
		}
	}
	return s;
}

std::string renderVarAsSVG(std::string & s, DDXLaser * laser)
{
	unsigned int i;
	char tmpRange [1024];
	char tmpAngle [1024];

	s += "<?xml version=\"1.0\"?>\n"
	"<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\"\n"
	"\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n"
	"<svg xmlns=\"http://www.w3.org/2000/svg\"\n"
	"xmlns:xlink=\"http://www.w3.org/1999/xlink\"\n"
	"id=\"canvas\"\n" 
	"viewBox=\"0 0 450 450\"\n"
	"width=\"100%\" \n"
	"height=\"100%\"\n" 
	"xml:space=\"preserve\"\n"
	"onload=\"init(evt)\"\n" 
	"onresize=\"init(evt)\">\n" 
	"<style type=\"text/css\">\n" 
	".circle\n" 
	"{\n" 
	"stroke: black; \n" 
	"stroke-width: 0.5;\n" 
	"fill: green;\n" 
	"fill-opacity: 1;\n" 
	"}\n" 
	".cenCircle\n" 
	"{\n" 
	"stroke: blue; \n" 
	"stroke-width: 1;\n" 
	"fill: red;\n" 
	"fill-opacity: 1;\n" 
	"}\n" 

	"</style>\n" 

	"<script>\n" 
	"<![CDATA[\n" 
	"     var R   = 1.5;\n" 
	"     function init()\n"
	"     {\n" 
	// this is for the resizing stuff
	"          var svgroot = document.documentElement;\n"
    "            var vbWidth;\n"
    "            var vbHeight;\n"
    "            if (!window.innerWidth) {\n"
    "                vbWidth = svgroot.viewport.width;\n"
    "            }\n"
    "            else {\n"
    "                vbWidth = window.innerWidth;\n"
    "            } \n"
    "            if (!window.innerHeight) {\n"
    "                vbHeight = svgroot.viewport.height;\n"
    "            }\n"
    "            else {\n"
    "                vbHeight = window.innerHeight;\n"
    "            }\n"                
    "            var vbString = \"0 0 \"+vbWidth+\" \"+vbHeight;\n"
	"			svgroot.setAttributeNS(null,\"viewBox\",vbString);\n";

	s += " var res = (Math.min((vbWidth/2), vbHeight)/82); \n" 

		"	var numGrids = Math.min(vbWidth, vbHeight)/(res*2);\n"
	"     var spacing = 2*R+10;\n"; 

/* this is the centre circle */	
		s += "       var canvas = document.getElementById(\"canvas\");\n";
		s += "var cenCircle = createCircle(vbWidth/2, vbHeight, 10, \"cenCircle\");\n";
		s+= 		 "   canvas.appendChild(cenCircle);\n";

	float phaseShift = laser->angle(0);	
	float tmp = 0;
	float tmp2 = 0;
	float tmpX = 0;
	float tmpY = 0;
	for ( i = 0; i < laser->nSegs(); i++ ){

		tmpY = laser->range(i) * sin(laser->angle(i) - phaseShift);
		tmpX = laser->range(i) * cos(laser->angle(i) - phaseShift);
		sprintf(tmpRange, "%f", tmpX);
		sprintf(tmpAngle, "%f", tmpY);
		if (tmp < tmpX)
			tmp = tmpX;
		if (tmp2 < tmpY)
			tmp2 = tmpY;

		s += "           var circle = createCircle(vbWidth/2+(res*";
		s += tmpRange;
		s += "), vbHeight-(res *";
		s += tmpAngle;
		s += "), R, \"circle\");\n";
		s+= 		 "            canvas.appendChild(circle);\n";
	}
	s += "\n}\n";
	s += "     function createCircle(x, y, r, type)\n" 
		"     {\n" 
		"       var circle = document.createElementNS(\"http://www.w3.org/2000/svg\", \"circle\");\n" 
		"       circle.setAttribute(\"class\", type);\n"
	" 		 circle.setAttribute(\"cx\", x);\n"
	"	     circle.setAttribute(\"cy\", y);\n"
	"	     circle.setAttribute(\"r\", r);\n"

	"       var group = document.createElementNS(\"http://www.w3.org/2000/svg\", \"g\");\n" 
	"       group.appendChild(circle);\n" 
	"       return group;\n" 
	"     }\n" 

	"     ]]>\n" 
	"   </script>\n" 

	"</svg>\n"; 
	return s;
}


string renderVarAsXML(string & s, RtxParseVar * v,unsigned int dim,int * arrayDim,
		unsigned int indentLevel, bool pretty, void * vbuffer, double timeStamp)
{
	char * buffer = (char*)vbuffer;
	char tmp[1024];
	unsigned int ui;
	signed int i, j;
	int size = 0;

	if (v == NULL)
		return s;

	if (indentLevel == 0) {
			s += "<ddxVars>\n";
		}
	if (pretty) {
		for (ui=0; ui<=indentLevel; ui++) 
			tmp[ui] = '\t';
		tmp[indentLevel+1] = 0;
		s += tmp;
	}
	if (indentLevel == 0) {
	    s += "<timestamp type=\"double\" dim=\"0\">\n";
	    if (pretty) {
		    for (ui=0; ui<=indentLevel*2; ui++) 
			    tmp[ui] = '\t';
		    tmp[indentLevel*2+1] = 0;
			s += tmp;
		}
		sprintf(tmp,"<value>%.*g</value>\n",15,timeStamp);
		s += tmp;
	    s += "</timestamp>\n";
	}
	  
	if (v->type == rtx_struct_t) {
		RtxParseVar * vit = v->subVar;
		sprintf(tmp," <%s type=\"struct\" dim=\"%d\">\n", v->name, v->dim);
		s += tmp;
		//add element arraySize and show waring if not displaying all 
		//if ((v->type == rtx_struct_t) && (dim>0)) {
		//	s += "<warning> displaying first object only </warning>";
		//}
		if (dim > 0) {
			s+= "<arraySize>";
			for (ui=0; ui<dim; ui++) {
				sprintf (tmp," %d ", arrayDim[ui]);
				s += tmp;
			}
			s+= "</arraySize>";
		}
		//not right yet!!!
		if (vit->dim > 0) {
			fprintf(stderr, "in dim > 0 for var = %s\n", vit->name);
			size = vit->size/vit->arrayDim[0];
			for (j = 0; j < vit->arrayDim[0]; j++)
			{
				fprintf(stderr, "in for v->dim = %d j = %d\n", v->dim, j);
				s = renderVarAsXML (s, vit, 0, vit->arrayDim+j, indentLevel+j, 
					pretty,(buffer==NULL)?NULL:(buffer + vit->offset ), timeStamp);

				size += v->arrayDim[j];

			}
		}


		#if 0
		for (i = 0; i < (v->dim+1); i++) {
		vit = v->subVar;
		size = vit->size/vit->arrayDim[0];
		fprintf(stderr, "vit size = %d, arraydim = %d size = %d", vit->size, vit->arrayDim[0], size);
		#endif
		while (vit != NULL) {
			s = renderVarAsXML (s, vit, vit->dim, vit->arrayDim, indentLevel+1, 
					pretty,(buffer==NULL)?NULL:(buffer + vit->offset), timeStamp);
			vit = vit->next;
		}
	//	}
		
	} else {

		switch (v->type) {
			case rtx_char_t : 
				sprintf(tmp,"<%s type=\"char\" dim=\"%d\">\n",v->name, v->dim);
				s += tmp;
				break;
			case rtx_short_t : 
				sprintf(tmp,"<%s type=\"short\" dim=\"%d\">\n",v->name, v->dim);
				s += tmp;
				break;
			case rtx_int_t : 
				sprintf(tmp,"<%s type=\"int\" dim=\"%d\">\n",v->name, v->dim);
				s += tmp;
				break;
			case rtx_long_t : 
				sprintf(tmp,"<%s type=\"long\" dim=\"%d\">\n",v->name, v->dim);
				s += tmp;
				break;
			case rtx_float_t : 
				sprintf(tmp,"<%s type=\"float\" dim=\"%d\">\n",v->name, v->dim);
				s += tmp;
				break;
			case rtx_double_t : 
				sprintf(tmp,"<%s type=\"double\" dim=\"%d\">\n",v->name, v->dim);
				s += tmp;
				break;
		}
	}
	if (pretty) {
		for (ui=0; ui<=indentLevel*2; ui++) 
			tmp[ui] = '\t';
		tmp[indentLevel*2+1] = 0;
		s += tmp;
	}
	if (buffer != NULL) {
		if ((dim > 0) && (v->type != rtx_struct_t))	
		{
			s+= "<arraySize>";
			for (ui=0; ui<dim; ui++) {
				sprintf (tmp," %d ", arrayDim[ui]);
				s += tmp;
			}

			s+= "</arraySize>";
		}
		switch (v->type) {
			case rtx_char_t : 
				{
					char *c = (char *)(buffer);
					switch (dim) {
						case 0: 
							if (isprint(*c)) {
								sprintf(tmp,"<value> %d 0x%02X '%c'</value>\n",*c,*c,*c); 
							} else {
								sprintf(tmp,"<value> %d 0x%02X </value>\n",*c,*c); 
							}
							s += tmp;
							break;
						case 1: 
							s += "<value> [ ";
							for (i=0;i<arrayDim[0];i++) {
								sprintf(tmp,"%02X ",c[i]); 
								s += tmp;
							}
							s += "] </value>\n";
							break;
						default : break;
					}
				}
				break;
			case rtx_short_t : 
				{
					short * c = (short *)(buffer);
					switch (dim) {
						case 0: 
							sprintf(tmp,"<value> %d 0x%04X </value>\n",*c,*c); 
							s += tmp;
							break;
						case 1: 
							s += "<value> [ ";
							for (i=0;i<arrayDim[0];i++) {
								sprintf(tmp,"%d ",c[i]); 
								s += tmp;
							}
							s += "] </value>\n";
							break;
						default : break;
					}
				}
				break;
			case rtx_int_t : 
				{
					int * c = (int *)(buffer);
					switch (dim) {
						case 0: 
							sprintf(tmp,"<value> %d </value>\n",*c); 
							s += tmp;
							break;
						case 1: 
							s += "<value> [ ";
							for (i=0;i<arrayDim[0];i++) {
								sprintf(tmp,"%d ",c[i]); 
								s += tmp;
							}
							s += "]</value>\n";
							break;
						default : break;
					}
				}
				break;
			case rtx_long_t : 
				{
					long * c = (long *)(buffer);
					switch (dim) {
						case 0: 
							sprintf(tmp,"<value>%ld 0x%08lX</value>\n",*c,*c); 
							s += tmp;
							break;
						case 1: 
							s += "<value> [ ";
							for (i=0;i<arrayDim[0];i++) {
								sprintf(tmp,"%ld ",c[i]); 
								s += tmp;
							}
							s += "] </value>\n";
							break;
						default : break;
					}
				}
				break;
			case rtx_float_t :
				{
					float * c = (float *)(buffer);
					switch (dim) {
						case 0: 
							sprintf(tmp,"<value> %e </value>\n",*c); 
							s += tmp;
							break;
						case 1: 
							s += "<value> [ ";
							for (i=0;i<arrayDim[0];i++) {
								sprintf(tmp,"%e ",c[i]); 
								s += tmp;
							}
							s += "] </value>\n";
							break;
						default : break;
					}
				}
				break;
			case rtx_double_t :
				{
					double * c = (double *)(buffer);
					switch (dim) {
						case 0: 
							sprintf(tmp,"<value>%.*g</value>\n",15,*c); 
							s += tmp;
							break;
						case 1: 
							s += " <value> [ ";
							for (i=0;i<arrayDim[0];i++) {
								sprintf(tmp,"%.*g ",15,c[i]); 
								s += tmp;
							}
							s += "] </value>\n";
							break;
						default : break;
					}
				}
				break;
		}
		if (pretty) {
			for (ui=0; ui<=indentLevel; ui++) 
				tmp[ui] = '\t';
			tmp[indentLevel+1] = 0;
			s += tmp;
		}
		s += "</";
		s += v->name;
		s += ">\n";
	}
	if (indentLevel == 0) {
		s+="</ddxVars>";
	}
	return s;
}









string renderStructHelper(RtxParseVar * subVar)
{
	string s;
	char tmp[1024];

	switch (subVar->type) {
		case rtx_struct_t :
			sprintf(tmp,"<xsd:element name=\"%s\" type=\"%s_type\"/>\n", subVar->name, subVar->name);
			s += tmp;
			break;
		case rtx_char_t : 
			sprintf(tmp,"<xsd:element name=\"%s\" type=\"xsd:byte\"/>\n", subVar->name);
			s += tmp;
			break;
		case rtx_short_t : 
			sprintf(tmp,"<xsd:element name=\"%s\" type=\"xsd:short_\"/>\n", subVar->name);
			s += tmp;
			break;
		case rtx_int_t : 
			sprintf(tmp,"<xsd:element name=\"%s\" type=\"xsd:int_\"/>\n", subVar->name);
			s += tmp;
			break;
		case rtx_long_t : 
			sprintf(tmp,"<xsd:element name=\"%s\" type=\"xsd:long_\"/>\n", subVar->name);
			s += tmp;
			break;
		case rtx_float_t : 
			sprintf(tmp,"<xsd:element name=\"%s\" type=\"xsd:float_\"/>\n", subVar->name);
			s += tmp;
			break;
		case rtx_double_t : 
			sprintf(tmp,"<xsd:element name=\"%s\" type=\"xsd:double_\"/>\n", subVar->name);
			s += tmp;
			break;
	}

	return s;
}

string renderVarAsXSD(string & s, RtxParseVar * v,unsigned int dim,int * arrayDim,
		unsigned int indentLevel, bool pretty, void * vbuffer)
{
	char * buffer = (char*)vbuffer;
	char tmp[1024];
	unsigned int ui;
	RtxParseVar * vit;
	RtxParseVar * vwh;
	bool first = false;
			
fprintf(stderr, "In renderVarAsXSD var name = %s\n", v->name) ;
			
	
	if (v == NULL)
		return s;
	if (indentLevel == 0)	
	{
		s += "<?xml version=\"1.0\"?>\n";
		s += "<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n";
		first = true;
	}

	for (ui=0; ui<(indentLevel+1); ui++) 
		tmp[ui] = '\t';
	tmp[indentLevel+1] = 0;
	s += tmp;
	vwh = v;
	
	while (vwh != NULL) {
		sprintf(tmp,"<xsd:complexType name=\"%s_type\">\n", vwh->name);
		s += tmp;
		// add more indent
		s += "<xsd:sequence>\n";
		// add more indent
		s += "<xsd:element name=\"type\" type=\"xsd:string\"/>\n";
		s += "<xsd:element name=\"dim\" type=\"xsd:int_\"/>\n";

		if (vwh->type == rtx_struct_t) {
			vit = vwh->subVar;
			while (vit != NULL)
			{
				//s += renderStructHelper(vit);
				sprintf(tmp,"<xsd:element name=\"%s\" type=\"%s_type\"/>\n", vwh->name, vit->name);
				s += tmp;
			
				vit = vit->next;
			}
		} else {
			s += renderStructHelper(vwh);
		}
		
		s += "</xsd:sequence>\n";
		s += "</xsd:complexType>\n";
#if 1
		if (vwh->subVar != NULL) {
			vit = vwh->subVar;
			s = renderVarAsXSD (s, vit, vit->dim, vit->arrayDim, indentLevel+1, 
					pretty,(buffer==NULL)?NULL:(buffer + vit->offset));
		}
#endif		
		vwh = vwh->next;
	}
	

	if (indentLevel == 0) {
		s += renderStructHelper(v);
		//sprintf(tmp,"\n\n<xsd:element name=\"xml_%s\" type=\"%s_type\"/>", v->name, v->name);
		//s += tmp;
		s += "</xsd:schema>\n";
	}

	return s;
}

#if 0
string renderVarAsXSD(string & s, RtxParseVar * v,unsigned int dim,int * arrayDim,
		unsigned int indentLevel, bool pretty, void * vbuffer)
{
	char * buffer = (char*)vbuffer;
	char tmp[1024];
	unsigned int ui;
	RtxParseVar * vit;
	RtxParseVar * vwh;
	bool first = false;
			
fprintf(stderr, "In renderVarAsXSD var name = %s\n", v->name) ;
			
	
	if (v == NULL)
		return s;
	if (indentLevel == 0)	
	{
		s += "<?xml version=\"1.0\"?>\n";
		s += "<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n";
		first == true;
	}

	for (ui=0; ui<(indentLevel+1); ui++) 
		tmp[ui] = '\t';
	tmp[indentLevel+1] = 0;
	s += tmp;
	vwh = v;
	
	while (vwh != NULL) {
		if (first)
			sprintf(tmp,"<xsd:complexType name=\"%s_type\">\n", vwh->name);
		else
			sprintf(tmp,"<xsd:complexType name=\"%s_type_%d\">\n", vwh->name, indentLevel);
		s += tmp;
		// add more indent
		s += "<xsd:sequence>\n";
		// add more indent
		s += "<xsd:element name=\"type\" type=\"xsd:string\"/>\n";
		s += "<xsd:element name=\"dim\" type=\"xsd:int_\"/>\n";

		if (vwh->type == rtx_struct_t) {
			indentLevel++;	
			vit = vwh->subVar;
			while (vit != NULL)
			{
				//s += renderStructHelper(vit);
				if (first)
					sprintf(tmp,"<xsd:element name=\"%s\" type=\"%s_type\"/>\n", vwh->name, vit->name);
				else
					sprintf(tmp,"<xsd:element name=\"%s\" type=\"%s_type_%d\"/>\n", vwh->name, vit->name, indentLevel);
				s += tmp;
			
				vit = vit->next;
			}
		} else {
			s += renderStructHelper(vwh);
		}
		
		s += "</xsd:sequence>\n";
		s += "</xsd:complexType>\n";
#if 1
		if (vwh->subVar != NULL) {
			vit = vwh->subVar;
			s = renderVarAsXSD (s, vit, vit->dim, vit->arrayDim, indentLevel, 
					pretty,(buffer==NULL)?NULL:(buffer + vit->offset));
		}
#endif		
		vwh = vwh->next;
	}
	

	if (indentLevel == 0) {
		s += renderStructHelper(v);
		//sprintf(tmp,"\n\n<xsd:element name=\"xml_%s\" type=\"%s_type\"/>", v->name, v->name);
		//s += tmp;
		s += "</xsd:schema>\n";
	}





#if 0
	if (v->type == rtx_struct_t) {
		RtxParseVar * vit = v->subVar;
			
		
		//add element arraySize and show waring if not displaying all 
		if ((v->type == rtx_struct_t) && (dim>0)) {
			s += "<warning> displaying first object only </warning>";
		}
		while (vit != NULL) {
			s = renderVarAsXML (s, vit, vit->dim, vit->arrayDim, indentLevel+1, 
					pretty,(buffer==NULL)?NULL:(buffer + vit->offset));
			vit = vit->next;
		}
	} else {
		switch (v->type) {
			case rtx_char_t : 
				sprintf(tmp,"<%s type=\"char\" dim=\"%d\">\n",v->name, v->dim);
				s += tmp;
				break;
			case rtx_short_t : 
				sprintf(tmp,"<%s type=\"short\" dim=\"%d\">\n",v->name, v->dim);
				s += tmp;
				break;
			case rtx_int_t : 
				sprintf(tmp,"<%s type=\"int\" dim=\"%d\">\n",v->name, v->dim);
				s += tmp;
				break;
			case rtx_long_t : 
				sprintf(tmp,"<%s type=\"long\" dim=\"%d\">\n",v->name, v->dim);
				s += tmp;
				break;
			case rtx_float_t : 
				sprintf(tmp,"<%s type=\"float\" dim=\"%d\">\n",v->name, v->dim);
				s += tmp;
				break;
			case rtx_double_t : 
				sprintf(tmp,"<%s type=\"double\" dim=\"%d\">\n",v->name, v->dim);
				s += tmp;
				break;
		}
	}
	if (pretty) {
		for (ui=0; ui<indentLevel*2; ui++) 
			tmp[ui] = '\t';
		tmp[indentLevel*2] = 0;
		s += tmp;
	}
	if (buffer != NULL) {
		if (dim > 0)	
		{
			s+= "<arraySize>";
			for (ui=0; ui<dim; ui++) {
				sprintf (tmp," %d ", arrayDim[ui]);
				s += tmp;
			}

			s+= "</arraySize>";
		}
		switch (v->type) {
			case rtx_char_t : 
				{
					char *c = (char *)(buffer);
					switch (dim) {
						case 0: 
							if (isprint(*c)) {
								sprintf(tmp,"<value> %d 0x%02X '%c'</value>\n",*c,*c,*c); 
							} else {
								sprintf(tmp,"<value> %d 0x%02X </value>\n",*c,*c); 
							}
							s += tmp;
							break;
						case 1: 
							s += "<value> [ ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%02X ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "...] </value>\n";
							} else {
								s += "] </value>\n";
							}
							break;
						default : break;
					}
				}
				break;
			case rtx_short_t : 
				{
					short * c = (short *)(buffer);
					switch (dim) {
						case 0: 
							sprintf(tmp,"<value> %d 0x%04X </value>\n",*c,*c); 
							s += tmp;
							break;
						case 1: 
							s += "<value> [ ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%d ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "...] </value>\n";
							} else {
								s += "] </value>\n";
							}
							break;
						default : break;
					}
				}
				break;
			case rtx_int_t : 
				{
					int * c = (int *)(buffer);
					switch (dim) {
						case 0: 
							sprintf(tmp,"<value> %d </value>\n",*c); 
							s += tmp;
							break;
						case 1: 
							s += "<value> [ ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%d ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "...] </value>\n";
							} else {
								s += "]</value>\n";
							}
							break;
						default : break;
					}
				}
				break;
			case rtx_long_t : 
				{
					long * c = (long *)(buffer);
					switch (dim) {
						case 0: 
							sprintf(tmp,"<value>%ld 0x%08lX</value>\n",*c,*c); 
							s += tmp;
							break;
						case 1: 
							s += "<value> [ ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%ld ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "...] </value>\n";
							} else {
								s += "] </value>\n";
							}
							break;
						default : break;
					}
				}
				break;
			case rtx_float_t :
				{
					float * c = (float *)(buffer);
					switch (dim) {
						case 0: 
							sprintf(tmp,"<value> %e </value>\n",*c); 
							s += tmp;
							break;
						case 1: 
							s += "<value> [ ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%e ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "...] </value>\n";
							} else {
								s += "] </value>\n";
							}
							break;
						default : break;
					}
				}
				break;
			case rtx_double_t :
				{
					double * c = (double *)(buffer);
					switch (dim) {
						case 0: 
							sprintf(tmp,"<value>%e</value>\n",*c); 
							s += tmp;
							break;
						case 1: 
							s += " <value> [ ";
							for (i=0;i<MIN(arrayDim[0],10);i++) {
								sprintf(tmp,"%e ",c[i]); 
								s += tmp;
							}
							if (arrayDim[0] > 10) { 
								s += "...] </value>\n";
							} else {
								s += "] </value>\n";
							}
							break;
						default : break;
					}
				}
				break;
		}
		if (pretty) {
			for (ui=0; ui<indentLevel; ui++) 
				tmp[ui] = '\t';
			tmp[indentLevel] = 0;
			s += tmp;
		}
		s += "</";
		s += v->name;
		s += ">\n";
	}
	if (pretty && (indentLevel == 0)) {
		s+="</ddxVars>";
	}
#endif
	return s;
}
#endif


