#include <string.h>

#include "DDXWebPost.h"

void post_hash_to_map(void *key, void *data, int k, int m, int *stop_iter, void *context)
{
	int debug = 0;
	PostMap * pmap = (PostMap *) context;
	string varName((char *)key);
	string value( (char *)data );

	unsigned int dotPos, dotPos2;
	bool first = true;
	vector<pair<string, vector<int> > > tmpPVec;
	vector <int> intVec;
	string betweenDots;
	string nameWOIndex, index;

	unsigned int i, j;

	if (debug)
		cout << "[post_to_map] entire var is " << varName << endl;

	dotPos = 0;
	dotPos2 = varName.find_first_of(".", dotPos);
	while (string::npos != dotPos2 || string::npos != dotPos) 
	{
		betweenDots = varName.substr(dotPos, dotPos2-dotPos);
		if (debug)
			cout << "[post_to_map] betweenDots " << betweenDots << endl;
		i = 0;
		j = 0;
		first = true;
		nameWOIndex = betweenDots;
#ifdef PERCENT_BRACKETS
		i = tmpStr.find_first_of("%", j);
		j = tmpStr.find_first_of("%", (i+1));
#else
		i = betweenDots.find_first_of("[", j);
		j = betweenDots.find_first_of("]", (i+1));
#endif
		while ( ( i != string::npos) && ( j != string::npos)  )
		{
#ifdef PERCENT_BRACKETS
			tmpStrI = tmpStr.substr(i+3, (j-(i+3)));
#else			
			index = betweenDots.substr(i+1, (j-(i+1)));
#endif			

			if (debug)
				cout << "[post_to_map] index " << index << endl;
			intVec.push_back(atoi(index.c_str()));
			if (first) // separate variable name from indicies 
			{
				nameWOIndex = betweenDots.substr(0, i);
				first = false;
			}
#ifdef PERCENT_BRACKETS
			i = tmpStr.find_first_of("%", j);
			j = tmpStr.find_first_of("%", (i+1));
#else			
			i = betweenDots.find_first_of("[", j);
			j = betweenDots.find_first_of("]", (i+1));
#endif
		}
		if (debug)
			cout << "[post_to_map] name without index " << nameWOIndex << endl;

		tmpPVec.push_back(make_pair(nameWOIndex, intVec));
		intVec.clear();

		dotPos = varName.find_first_not_of(".", dotPos2);
		dotPos2 = varName.find_first_of(".", dotPos);
	}

	(*pmap).insert(make_pair(tmpPVec, value));
	if (debug)
		cout << "[post_to_map] value is " << value << endl; 
}

bool modify_var(char * cbuffer, RtxParseVar * subV, PostMap::iterator mit, int debug) {

	int itmp;
	char ctmp;
	short stmp;
	long ltmp;
	double dtmp;
	float ftmp;
	bool postok;

	switch (subV->type) {
		case rtx_char_t :
			ctmp = (char) *mit->second.c_str();
			memcpy(cbuffer, &ctmp, sizeof(char));
			if(debug)
				cout << "[post] got a char  " << subV->name << " string = "<< mit->second.c_str() << " value = " << "dont know yet" << endl;
			break;
		case rtx_short_t :
			stmp = (short) atoi (mit->second.c_str());
			memcpy(cbuffer, &stmp, sizeof(short));
			if(debug)
				cout << "[post] got a short  " << subV->name << " string = "<< mit->second.c_str() << " value = " << stmp << endl;
			break;
		case rtx_int_t :
			itmp = atoi (mit->second.c_str());
			memcpy(cbuffer, &itmp, sizeof(int));
			if(debug)
				cout << "[post] got an int  " << subV->name << " string = "<< mit->second.c_str() << " value = " << itmp << endl;

			break;
		case rtx_long_t :
			ltmp = (long) atol (mit->second.c_str());
			memcpy(cbuffer, &ltmp, sizeof(long));
			if(debug)
				cout << "[post] got a long  " << subV->name << " string = "<< mit->second.c_str() << " value = " << ltmp << endl;
			break;
		case rtx_float_t :
			ftmp = (float) atof (mit->second.c_str());
			memcpy(cbuffer, &ftmp, sizeof(float));
			if (debug)
				cout << "[post] got a float  " << subV->name << " string = "<< mit->second.c_str() << " value = " << ftmp << endl;
			break;
		case rtx_double_t :
			dtmp = (double) atof (mit->second.c_str());
			memcpy(cbuffer, &dtmp, sizeof(double));
			if (debug)
				cout << "[post] got a double  " << subV->name << " string = "<< mit->second.c_str() << " value = " << dtmp << endl;
			break;
		default :
			break;
	}		
	postok = true;
	return postok;
}


bool find_where_to_write(DDXVariable * var, map<vector <pair< string, vector<int> > >, string>::iterator mit, int debug) 
{
	bool postok = true;
	RtxParseVar * subV;
	char * cbuffer;
	int j, size;
	unsigned int i;
	
		cbuffer = (char*)var->rawPointer();
		subV = var->getParsedVar();
	
		for (i = 1; i < mit->first.size(); i++)
		{
			subV = subV->subVar;
			if (debug)
				cout << "[find_where] subV->dim   " << subV->dim << endl;				
			
			while ((subV != NULL) && (subV->name != mit->first[i].first) ) {
				subV = subV->next;
			}
			if (subV->dim > 0) {
				size = subV->size/subV->arrayDim[0];
				for(j = 0; j < subV->dim; j++) 
				{
					cbuffer += (mit->first[i].second[j] * size);
					if (debug)
						cout << "[post] added mit = " << mit->first[i].second[j] << " * size = " <<size << " = " << mit->first[i].second[j]*size << endl;
					size *= subV->arrayDim[j];
				}		
			}
		}
		if (debug)
			cout << "[find_where] bottom of tree name = " << subV->name << endl;

		if (subV->type == rtx_struct_t) {
			cout << "post data is a struct at bottom level i don't like that"
			<< endl;
			return false;
		}

		cbuffer += subV->offset;
	
		postok = modify_var( cbuffer, subV, mit, debug);
		
		rtx_parse_free_var(subV);
		return postok;
}







