
//  The purpose of this program is to emulate various Webcams.
//  Rather than using RTX_HTTPD, RTX_INET is used.

#include <assert.h>
#include <signal.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <strings.h>
#include <pthread.h>
#include <time.h>
#include <math.h>

#include <string>
#include <map>

#include <rtx/defines.h>
#include <rtx/main.h>
#include <rtx/message.h>
#include <rtx/time.h>
#include <rtx/error.h>
#include <rtx/command.h>
#include <rtx/parse.h>
#include <rtx/inet.h>
#include <rtx/httpd.h>
#include <rtx/getopt.h>

#include <DDXStore.h>
#include <DDXVideo.h>
#include <JpegCodec.h>

static char rcsid[] RTX_UNUSED = "$Id: DDXVideoServer.cpp 3072 2008-05-15 04:48:23Z roy029 $";

using namespace std;

int port = 8000;
double timeout = 3.0;
int quality = 75;
int debug = 0;
int direct = 0;
const char *name = "video";
DDXStore store;
DDXVideo video;

const char *help = "CSIRO Video Server Project\nServe video to a browser";

RtxGetopt myOpts[] = {
	{ "port", "Select tcp port",
		{ { RTX_GETOPT_INT, &port, "port"}, RTX_GETOPT_END_ARG } },
	{ "name", "Name of Video in Store",
	 	{ { RTX_GETOPT_STR, &name, "name"}, RTX_GETOPT_END_ARG } },
	{ "dbg", "Select debug level",
		{ { RTX_GETOPT_INT, &debug, "debug"}, RTX_GETOPT_END_ARG } },
	{ "quality", "Select encoding quality, in [50-100]",
		{ { RTX_GETOPT_INT, &quality, "quality"}, RTX_GETOPT_END_ARG } },
	RTX_GETOPT_END 
};

// If the Connection is broken then break out of handler

#define RESPONSE(A) if( rtx_inet_write(r->sock, A, strlen(A), NULL) != (int) strlen(A) ) break;

void *
handler(void *arg1, void *arg2) {
	int i, n;
	RtxInetTcpClient *r = (RtxInetTcpClient *) arg1;
	int field = 0;
	char str[200];
	char str2[200];
	char query[800];
	char method[10];
	char url[100];
	JpegCodec jpeg(75);

	n = rtx_inet_read (r->sock, query, 800, NULL);
	query[n] = 0;
	sscanf(query, "%s %s", method, url);
	printf("Method %s URL %s \n", method, url);

	// Simple Switch on Second Character of URL 
	// Ideally we should have a Hash table for all the different type of Webcams

        switch( url[1] ) {
	  case 'o': case 'O': // OneShotimage.jpg 

  	    printf("*** Request for image\n");
	    if (!video.read(timeout,1)) { 
		rtx_error("Failed to read video frame"); return 0; }
	    jpeg.encode(&video,field);

            RESPONSE("HTTP/1.0 200 OK\r\n");
            RESPONSE("Content-Type: image/jpeg\r\n");         
	    sprintf(str, "Content-Length: %d\r\n\r\n", (int)jpeg.bsize());
            RESPONSE(str);
            rtx_inet_write(r->sock,(const char *)jpeg.getBuffer(),(int)jpeg.bsize(),NULL);
	    break;

	  case 'i': case 'I': 

	    printf("*** Request for video\n");
	    // At the moment this does not work with FireFOX
	    // Whilst the data is being sent, the browser does not update the image
	    // At one point I got this to work, but I don't recall how :(
	    // It could be just a missing CR

            RESPONSE("HTTP/1.0 200 OK\r\n");
	    RESPONSE("Cache-Control: no-cache\r\n"); 
	    RESPONSE("Content-type: multipart/x-mixed-replace;boundary=myboundary\r\n");

	    for(i=0; i<10000; i++) {

	      printf("Video %d\n", i);
	      if (!video.read(timeout,1)) 
		{ rtx_error("Failed to read video frame"); return 0; }
	      jpeg.encode(&video,field);

	      RESPONSE("\r\n--myboundary\r\n");		// The -- indicates boundary
              RESPONSE("Content-Type: image/jpeg\r\n");         
	      sprintf(str, "Content-Length: %d\r\n", (int)jpeg.bsize());
              RESPONSE(str);

	      // Stuff for Sony Webcams
              // sprintf(str, "DataLen: %d\r\n", (int) jpeg.bsize()); 
	      // RESPONSE(str);
    	      // RESPONSE("CamTim: 2004-01-02 Fri 15:47:31\r\n");
              // RESPONSE("CamPos: 1110010ffb00e9cS\r\n");

              RESPONSE("\r\n");		// And now the content

              rtx_inet_write(r->sock,(const char *)jpeg.getBuffer(),(int)jpeg.bsize(),NULL);
	      }

	    RESPONSE("\r\n--myboundary--\r\n");		// The -- at the end indicates end of file
	    break;

	  case 's': case 'S': 
	    // This will test the multipart stuff
	    // It currently works !

	    printf("*** Request for status\n");
            RESPONSE("HTTP/1.0 200 OK\r\n");
	    RESPONSE("Cache-Control: no-cache\r\n"); 
	    RESPONSE("Content-type: multipart/x-mixed-replace;boundary=myboundary\r\n");

	    for(i=0; i<10000; i++) {

	      printf("Status %d\n", i);
	      if (!video.read(timeout,1)) 
		{ rtx_error("Failed to read video frame"); return 0; }
	      jpeg.encode(&video,field);

	      sprintf(str, "Jpeg %d Size %d\r\n", i, (int)jpeg.bsize());
	      sprintf(str2, "Content-Length: %d\r\n", (int)strlen(str));

	      RESPONSE("\r\n--myboundary\r\n");
              RESPONSE("Content-Type: text/plain\r\n");         
              RESPONSE(str2);
              RESPONSE("\r\n");		// And now the Content
              RESPONSE(str);
	      }

	    RESPONSE("\r\n--myboundary--\r\n");
	    break;

	  default:
            RESPONSE("HTTP/1.0 200 OK\r\n");
            RESPONSE("Content-Type: text/plain\r\n");         
            RESPONSE("Content-Length: 18\r\n\r\n");         
	    RESPONSE("DDX Video Server\r\n");
	  }


    	return 0;
}

int main(int argc, char **argv) 
{
	RtxInet * server;

	if( RTX_GETOPT_CMD( myOpts, argc, argv, NULL, help) == -1 )
		{ RTX_GETOPT_PRINT( myOpts, argv[0], NULL, help); exit(-1); }

        rtx_error_init ("VideoServer", RTX_ERROR_STDERR, NULL);

	if (!store.open()) { 
		return rtx_error("Failed to open ddx store"); }
	if (!video.lookupVariable(store,name,direct)) { 
		return rtx_error("Failed to lookup '%s'",name); }

        fprintf(stderr, "Initialising simple HTTPD server on port %d\n",port);

	server = rtx_inet_init(RTX_INET_TCP_SERVER, 
		NULL, port, NULL, 0, handler, NULL, NULL);
        if (!server) { fprintf(stderr, "inet_init() failed.\n"); exit(1); }

    	rtx_main_wait_shutdown(0);
	rtx_inet_done(server);
	store.close();
	return 0;
}
