/** \file
  Copyright (c) CSIRO ICT Robotics Centre
  \brief  Take a video frame from store and save as a raw tga
  \author Stephen.Nuske@csiro.au
  */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include <rtx/defines.h>
#include <rtx/getopt.h>
#include <rtx/error.h>

#include "DDXStore.h"
#include "DDXVideo.h"

static char rcsid[] RTX_UNUSED = "$Id: DDXVideoGrab.cpp 3071 2008-05-15 04:37:54Z roy029 $";

const char *name = "video";
unsigned int field=0;

const char           *help =
	"CSIRO Video Server Project\nGrab current video frame in store and save as raw TGA\n"
	"\t\tUsage: DDXVideoGrab <OPTIONS> filename";

RtxGetopt       myOpts[] = {
	{"name", "Name of Video Stream in Store ",
	 {{RTX_GETOPT_STR, &name, "name"}, RTX_GETOPT_END_ARG}},
	{"field", "The video field to save",
	 {{RTX_GETOPT_INT, &field, "field"}, RTX_GETOPT_END_ARG}},
	RTX_GETOPT_END
};


int main(int ac, char* av[])
{
	int             ret;
	char           *filename = NULL;

	if ((ret = RTX_GETOPT_CMD(myOpts, ac, av, rcsid, help)) == -1) {
		RTX_GETOPT_PRINT(myOpts, av[0], rcsid, help);
		exit(-1);
	}

	if (ret < ac)
		filename = av[ret];


	DDXStore store;
	DDXVideo video;
	
	if(!store.open(NULL,0,5))
	{
		rtx_error("Couldn't open store\n");
		exit(-1);
	} 

	if(!video.lookupVariable(store,name,true))
	{
		rtx_error("Couldn't lookup video variable (%s) from store\n", name);
		exit(-1);
	}

	if(!video.read(10.0,1))
	{
		rtx_error("Couldn't read video\n");
	}

	if(field > video.fields())
	{
		rtx_error("Not enough video fields available\n");
	}


	if(!video.saveAsTga(filename, field))
	{
		rtx_error("Couldn't save image to (%s)\n", filename);
	}
}
