#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>



#include "DDXVPConvert.h"

SDL_Surface* createSurface(unsigned int w, unsigned int h, unsigned int depth)
{
	Uint32 rmask, gmask, bmask, amask;

	/* SDL interprets each pixel as a 32-bit number, so our masks must depend
	   on the endianness (byte order) of the machine */
#if SDL_BYTEORDER == SDL_BIG_ENDIAN
	rmask = 0xff000000; gmask = 0x00ff0000; 
	bmask = 0x0000ff00; amask = 0x00000000; /* this value for alpha : 0x000000ff; */
#else
	rmask = 0x000000ff; gmask = 0x0000ff00; 
	bmask = 0x00ff0000; amask = 0x00000000; /* this value for alpha : 0xff000000; */
#endif
	SDL_Surface * tmp_surf = SDL_CreateRGBSurface(SDL_SWSURFACE,
			w,h, depth,rmask,gmask,bmask,amask);
	assert(tmp_surf != NULL);
	return tmp_surf;
}

void copyYUV420toOverlay(unsigned char *src[3],
		unsigned int width, unsigned int height,
		SDL_Overlay * overlay)
{
	unsigned char * dest[3];
	dest[0] = overlay->pixels[0];
	dest[1] = overlay->pixels[1];
	dest[2] = overlay->pixels[2];

	for(unsigned int i = 0; i < height; i++)
	{
		memcpy(dest[0], src[0], width);

		dest[0] += overlay->pitches[0];
		src[0] += width;
	}

	for(unsigned int k = 1; k <= 2; k++)
	{
		for(unsigned int i = 0; i < height / 2; i++)	      
		{
			memcpy(dest[k], src[k], width / 2);

			dest[k] += overlay->pitches[k];
			src[k] += (width + 1) / 2;
		}

		if(height % 2)
		{
			src[k] -= (width + 1) / 2;
			memcpy(dest[k], src[k], width / 2);
		}
	}

	for(unsigned int j = 0; j < height; j++)
	{
		for(unsigned int i = width; i < overlay->pitches[0]; i++)
		{
			dest[0][i] = src[0][width - 1];
		}

		dest[0] += overlay->pitches[0];
		src[0] += width;
	}

	for(unsigned int k = 1; k <= 2; k++)
	{
		for(unsigned int j = 0; j < height / 2; j++)
		{
			for(unsigned int i = width / 2; i < overlay->pitches[k]; i++)
			{
				dest[k][i] = src[k][width / 2 - 1];
			}

			dest[k] += overlay->pitches[k];
			src[k] += (width + 1) / 2;
		}

		if(height % 2)
		{
			src[k] -= (width + 1) / 2;

			for(unsigned int i = width / 2; i < overlay->pitches[k]; i++)
			{
				dest[k][i] = src[k][width / 2 - 1];
			}
		}
	}
}

#define YUV2RGB(y,u,v,r,g,b)                  \
	u -= 128; v -= 128;                       \
	r = y + ((v*1436) >> 10);                 \
	r = r < 0 ? 0 : r; r = r > 255 ? 255 : r; \
	g = y - ((u*352 + v*731) >> 10);          \
	g = g < 0 ? 0 : g; g = g > 255 ? 255 : g; \
	b = y + ((u*1814) >> 10);                 \
	b = b < 0 ? 0 : b; b = b > 255 ? 255 : b

void copyYUV420toSurface(unsigned char *src[3],
		unsigned int width, unsigned int height,
		SDL_Surface * surface)
{
	char * dest;

	unsigned int i,j,w2;
	w2 = width/2;
	for (j=0;j<height;j++) {
		unsigned int jw = j*width;
		unsigned int j2 = j/2 * w2;
		dest = (char*)surface->pixels + j*surface->pitch;
		for (i=0;i<width;i++) {
			unsigned int i2 = i/2;
			//printf("i %d j %d j*w+i %d (j*w2+i)/2 %d\n",
			//		i,j,j*width+i,(j/2)*w2+(i/2));
			int y,u,v, r,g,b;
			y = src[0][jw+i];
			v = src[1][j2+i2];
			u = src[2][j2+i2];
			YUV2RGB(y,u,v,r,g,b);
			*dest++ = r; *dest++ = g; *dest++ = b;
		}
	}
}

