#ifndef DDX_LASER_CLASS_H
#define DDX_LASER_CLASS_H

#include "DDXStore.h"
#include "DDXVariable.h"

#include <plsddx.h>



class DDXLaser : public DDXVariable {
	protected :
		bool lmssensor;
		PlsScan *pls;
		LmsScan *lms;

	public :
		DDXLaser();
		~DDXLaser();

	public :
		// DDX Interfaces 
		bool registerVariable(DDXStore & store, const std::string & name,
				bool lms, bool _direct = false);

		bool lookupVariable(DDXStore & store, const std::string & name,
				bool _direct = false);

	public :
		// Various accessors
		bool hasIntensity() const {return lmssensor;}
		bool isLms() const {return lmssensor;}
		bool isPls() const {return !lmssensor;}
		
		unsigned int infringement() const;
		unsigned int status() const;
		unsigned int nSegs() const;
		
		float resolution() const;
		float first() const;
		float angle(unsigned int i) const;

		float range(unsigned int i) const;
		unsigned char intensity(unsigned int i) const;
		
		float * ranges();
		unsigned char * intensities(); /* NULL for PLS */

		// Various accessors, the same but const
		const float * ranges() const;
		const unsigned char * intensities() const; /* NULL for PLS */
};



#endif // DDX_LASER_CLASS_H
