#define DDX_LASER_IMPLEMENTATION
#include <rtx/error.h>

#include "DDXLaser.h"

DDXLaser::DDXLaser() 
{
	lmssensor = false;
	pls = NULL;
	lms = NULL;
}

DDXLaser::~DDXLaser()
{
}

bool DDXLaser::registerVariable(DDXStore & store, const std::string & name,
				bool _lms, bool _direct)
{
	pls = NULL;
	lms = NULL;
	lmssensor = _lms;
	if (lmssensor) {
		DDX_STORE_REGISTER_TYPE(store.getId(),LmsScan);
		if (!store.registerVariable(*this,name,"LmsScan",_direct))
			return rtx_error_cpp("DDXLaser::registerVariable: LMS store.registerVariable failed");
		lms = (LmsScan*)rawPointer();
	} else {
		DDX_STORE_REGISTER_TYPE(store.getId(),PlsScan);
		if (!store.registerVariable(*this,name,"PlsScan",_direct))
			return rtx_error_cpp("DDXLaser::registerVariable: PLS store.registerVariable failed");
		pls = (PlsScan*)rawPointer();
	}
	return true;
}

bool DDXLaser::lookupVariable(DDXStore & store, const std::string & name,
				bool _direct)
{
	pls = NULL;
	lms = NULL;
	if (!store.lookupVariable(*this,name,_direct)) 
		return rtx_error_cpp("DDXLaser::lookupVariable: store.lookupVariable failed");
	
	lmssensor =
		(definition().find("intensity") < definition().length());
	if (lmssensor) {
		lms = (LmsScan*)rawPointer();
	} else {
		pls = (PlsScan*)rawPointer();
	}
	return true;
}

unsigned int DDXLaser::infringement() const
{
	if (lmssensor){
		if (lms == NULL) {
			if (verbose) return rtx_error("DDXLaser::infringement: LMS laser object not initialised"); else return (unsigned int)-1;
		} else
			return lms->infringe;
	} else {
		if (pls == NULL) {
			if (verbose) return rtx_error("DDXLaser::infringement: PLS laser object not initialised"); else return (unsigned int)-1;
		} else
			return pls->infringe;
	}
}

unsigned int DDXLaser::status() const
{
	if (lmssensor){
		if (lms == NULL) {
			if (verbose) return rtx_error("DDXLaser::status: LMS laser object not initialised"); else return (unsigned int)-1;
		} else
			return lms->status;
	} else {
		if (pls == NULL) {
			if (verbose) return rtx_error("DDXLaser::status: PLS laser object not initialised"); else return (unsigned int)-1;
		} else
			return pls->status;
	}
}

unsigned int DDXLaser::nSegs() const
{
	if (lmssensor){
		if (lms == NULL) {
			if (verbose) return rtx_error("DDXLaser::nSegs: LMS laser object not initialised"); else return (unsigned int)-1;
		} else
			return lms->nSegs;
	} else {
		if (pls == NULL) {
			if (verbose) return rtx_error("DDXLaser::nSegs: PLS laser object not initialised"); else return (unsigned int)-1;
		} else
			return pls->nSegs;
	}
}

float DDXLaser::resolution() const
{
	if (lmssensor){
		if (lms == NULL) {
			if (verbose) return (float)rtx_error("DDXLaser::resolution: LMS laser object not initialised"); else return 0.0;
		} else
			return lms->res;
	} else {
		if (pls == NULL) {
			if (verbose) return (float)rtx_error("DDXLaser::resolution: PLS laser object not initialised"); else return 0.0;
		} else
			return pls->res;
	}
}

float DDXLaser::first() const
{
	if (lmssensor){
		if (lms == NULL) {
			if (verbose) return (float)rtx_error("DDXLaser::first: LMS laser object not initialised"); else return 0.0;
		} else
			return lms->first;
	} else {
		if (pls == NULL) {
			if (verbose) return (float)rtx_error("DDXLaser::first: PLS laser object not initialised"); else return 0.0;
		} else
			return pls->first;
	}
}

float DDXLaser::angle(unsigned int i) const
{
	if (lmssensor){
		if (lms == NULL) {
			if (verbose) return (float)rtx_error("DDXLaser::angle: LMS laser object not initialised"); else return 0.0;
		} else
			return lms->first + i*lms->res;
	} else {
		if (pls == NULL) {
			if (verbose) return (float)rtx_error("DDXLaser::angle: PLS laser object not initialised"); else return 0.0;
		} else
			return pls->first + i*pls->res;
	}
}

float DDXLaser::range(unsigned int i) const
{
	if (lmssensor){
		if (lms == NULL) {
			if (verbose) return (float)rtx_error("DDXLaser::range: LMS laser object not initialised");  else return 0.0;
		} else
			return lms->range[i];
	} else {
		if (pls == NULL) {
			if (verbose) return (float)rtx_error("DDXLaser::range: PLS laser object not initialised"); else return 0.0;
		} else
			return pls->range[i];
	}
}

unsigned char DDXLaser::intensity(unsigned int i) const
{
	if (lmssensor){
		if (lms == NULL) {
			if (verbose) rtx_error("DDXLaser::intensity: LMS laser object not initialised"); 
			return 0;
		} 
		else
			return lms->intensity[i];
	} else {
		return 0;
	}
}

const float * DDXLaser::ranges() const
{
	if (lmssensor){
		if (lms == NULL) {
			if (verbose) rtx_error("DDXLaser::ranges: LMS laser object not initialised"); 
			return NULL;
		} else
			return lms->range;
	} else {
		if (pls == NULL) {
			if (verbose) rtx_error("DDXLaser::ranges: PLS laser object not initialised"); 
			return NULL;
		} else
			return pls->range;
	}
}

float * DDXLaser::ranges() 
{
	if (lmssensor){
		if (lms == NULL) {
			if (verbose) rtx_error("DDXLaser::ranges: LMS laser object not initialised"); 
			return NULL;
		} else
			return lms->range;
	} else {
		if (pls == NULL) {
			if (verbose) rtx_error("DDXLaser::ranges: PLS laser object not initialised"); 
			return NULL;
		} else
			return pls->range;
	}
}

const unsigned char * DDXLaser::intensities() const
{
	if (lmssensor){
		if (lms == NULL) {
			if (verbose) rtx_error("DDXLaser::intensities: LMS laser object not initialised"); 
			return NULL;
		} else
			return (unsigned char*)(lms->intensity);
	} else {
		if (verbose) rtx_error("DDXLaser::intensities: function not available on PLS"); 
		return NULL;
	}
}

unsigned char * DDXLaser::intensities() 
{
	if (lmssensor){
		if (lms == NULL) {
			if (verbose) rtx_error("DDXLaser::intensities: LMS laser object not initialised"); 
			return NULL;
		} else
			return (unsigned char*)(lms->intensity);
	} else {
		if (verbose) rtx_error("DDXLaser::intensities: function not available on PLS"); 
		return NULL;
	}
}


