#ifndef MISSION_COMMAND_H
#define MISSION_COMMAND_H

#include <rtx/command.h>
#include "mission-scheduler.h"

#ifdef __cplusplus
extern "C" {
#endif


/**
 * Start a command line interface for the tasks in sched.
 * If missionFile is non null, then the mission is executed and the function 
 * triggers a rtx_main_signal_shutdown.
 * In both case, the function starts a threads and returns immediately.
 * This function is non-reentrant. Don't call it twice or it will fail 
 * */
extern
int mission_command_start(MissionScheduler * sched, 
		const char * prompt, const char * missionFile,
		int verbose);

/**
 * Terminates the command line interface. Stop the corresponding thread.
 * */
extern
int mission_command_terminate();

#ifdef __cplusplus
}
#endif


#endif // MISSION_COMMAND_H
