#ifndef MONITOR_THREAD_H
#define MONITOR_THREAD_H

#include <rtx/thread.h>
#include <rtx/error.h>
#include <rtx/message.h>

#include <DDXVariable.h>

struct DDXVariableChecker
{
	DDXVariableChecker() {}
	virtual ~DDXVariableChecker() {}

	/*** Set of functions which may be declared by a 
	 * Demand module, expected to be redefined by 
	 * real implementation ***/

	/** Returns the maximum allowed age of a variable for it 
	 * to be accepted **/
	virtual double maxVariableAge() const = 0;

	/** Returns true if the demand can be used for control **/
	virtual bool checkDemand(DDXVariable &dmd) const = 0;

	/** Copy the demand, eventually clipping the input **/
	virtual int copySanitizedDemand(DDXVariable &dmd) = 0 ;

	/** Fill the demand with a sane default value **/
	virtual int setDefaultDemand() = 0;
};

class MonitorThread
{
	protected:
		DDXVariable *demandVar;
		DDXVariableChecker *consumer;
		double maxCommandAge;

		RtxMutex *dataMtx;
		RtxThread *targetThread;
		void * target_thread_func();
		bool variable_accepted;

		friend void *target_thread_ext_func(void *);

	public:
		MonitorThread(DDXVariable *var, DDXVariableChecker *checker, double maxVarAge=1.0) {
			targetThread = NULL;
			dataMtx = NULL;
			maxCommandAge = maxVarAge;
			demandVar = var;
			consumer = checker;
			variable_accepted = false;
		}
		~MonitorThread();

		/** Called on startup or after reset **/
		int start();
		
		/** Called before a reset **/
		int stop();

		/** Set the data mutex for the monitoring thread 
		 * usually, from LowLevelLoop::getMutex() **/
		void setMutex(RtxMutex *mtx) {
			dataMtx = mtx;
		}
};


#endif // MONITOR_THREAD_H
