#include <rtx/timer.h>

#include "MonitorThread.h"

void *target_thread_ext_func(void * that)
{
	MonitorThread * dm = (MonitorThread*)that;
	return dm->target_thread_func();
}

MonitorThread::~MonitorThread()
{
	stop();
}

void *MonitorThread::target_thread_func()
{
	bool accept_variable = false;
	while (1){
		if (demandVar->read(consumer->maxVariableAge(),1)) {
			accept_variable = consumer->checkDemand(*demandVar);
		} else if (demandVar->hasTimedOut()) {
			/* timeout: the controlling program may be dead, just go into safe
			 * mode */
			accept_variable = false;
		} else {
			accept_variable = false;
			rtx_message("%s: Fatal error while reading 'demand'", 
					demandVar->getName().c_str());
			rtx_timer_sleep(0.1);
		}

		/** Logging status change **/
		if (accept_variable && !variable_accepted) {
			rtx_message("%s: demand accepted", 
					demandVar->getName().c_str());
		} else if (!accept_variable && variable_accepted) {
			rtx_message("%s: demand ignored", 
					demandVar->getName().c_str());
		}
#if 0
		printf("%s Accepted = %d %d |",demandVar->getName().c_str(),
				accept_variable, variable_accepted);
#endif
		variable_accepted = accept_variable;
#if 0
		printf("%d %d \n",accept_variable, variable_accepted);
#endif
		
		if (dataMtx) {
			rtx_mutex_lock(dataMtx); 
		}

		/** Updating the state **/
		if (variable_accepted) {
			consumer->copySanitizedDemand(*demandVar);
		} else {
			/* may write the demand back to the store, should it? */
			consumer->setDefaultDemand();
		}
		
		if (dataMtx) {
			rtx_mutex_unlock(dataMtx); 
		}
	}
	return NULL;
}


int MonitorThread::start()
{
	if (!demandVar->isRegistered()){
		return rtx_error("Can't start demand thread without initialising the demand variable");
	}

	/** just in case **/
	stop();

	targetThread = rtx_thread_create("Target Thread", 0, RTX_THREAD_SCHED_OTHER,
		   	RTX_THREAD_PRIO_MIN, 0, RTX_THREAD_CANCEL_DEFERRED, 
			target_thread_ext_func, this, NULL, NULL);

	if (targetThread == NULL) {
		return rtx_error("Failed to create target thread");
	}

	return 0;
}

int MonitorThread::stop()
{
	if (targetThread) {
		int ret = rtx_thread_destroy_sync(targetThread);
		targetThread = NULL;
		return ret;
	}
	return 0;
}


