#ifndef EXPORT_MODULE_H
#define EXPORT_MODULE_H

template <class ExportType>
class ExportModule : public GenericSensoriMotorModule
{
	protected:
		DDXVariable *exportVar;

		SensoriMotorModule<ExportType> *input;

	public:
		ExportModule(const std::string &name, 
				SensoriMotorModule<ExportType> *inp,
				DDXVariable *var) : 
			GenericSensoriMotorModule(name) {
			exportVar = var;
			input = inp;
			/** Register dependency to ensure correct running order **/
			dependsOn(input);
		}
		virtual ~ExportModule() {}

		virtual int run() {
			if (!exportVar->isRegistered()){
				return rtx_error("Module '%s': Export variable must be registered with DDX", 
						this->getName().c_str());
			}
			return exportVar->t_writefrom(input->getState())?0:1;
		}
};




#endif // EXPORT_MODULE_H
